/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.firehose;

import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.firehose.KinesisFirehose2Component;
import org.apache.camel.component.aws2.firehose.KinesisFirehose2Configuration;
import org.apache.camel.component.aws2.firehose.KinesisFirehose2Constants;
import org.apache.camel.component.aws2.firehose.KinesisFirehose2Producer;
import org.apache.camel.component.aws2.firehose.client.KinesisFirehoseClientFactory;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.services.firehose.FirehoseClient;

@UriEndpoint(firstVersion="3.2.0", scheme="aws2-kinesis-firehose", title="AWS Kinesis Firehose", syntax="aws2-kinesis-firehose:streamName", producerOnly=true, category={Category.CLOUD, Category.MESSAGING}, headersClass=KinesisFirehose2Constants.class)
public class KinesisFirehose2Endpoint
extends DefaultEndpoint
implements EndpointServiceLocation {
    @UriParam
    private KinesisFirehose2Configuration configuration;
    private FirehoseClient kinesisFirehoseClient;

    public KinesisFirehose2Endpoint(String uri, KinesisFirehose2Configuration configuration, KinesisFirehose2Component component) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        return new KinesisFirehose2Producer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot consume messages from this endpoint");
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (!this.configuration.isCborEnabled()) {
            System.setProperty(SdkSystemSetting.CBOR_ENABLED.property(), "false");
        }
        this.kinesisFirehoseClient = this.configuration.getAmazonKinesisFirehoseClient() != null ? this.configuration.getAmazonKinesisFirehoseClient() : KinesisFirehoseClientFactory.getKinesisFirehoseClient(this.configuration).getKinesisFirehoseClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getAmazonKinesisFirehoseClient()) && this.kinesisFirehoseClient != null) {
            this.kinesisFirehoseClient.close();
        }
        if (!this.configuration.isCborEnabled()) {
            System.clearProperty(SdkSystemSetting.CBOR_ENABLED.property());
        }
        super.doStop();
    }

    public FirehoseClient getClient() {
        return this.kinesisFirehoseClient;
    }

    public KinesisFirehose2Configuration getConfiguration() {
        return this.configuration;
    }

    public String getServiceUrl() {
        if (!this.configuration.isOverrideEndpoint()) {
            if (ObjectHelper.isNotEmpty((String)this.configuration.getRegion())) {
                return this.configuration.getRegion();
            }
        } else if (ObjectHelper.isNotEmpty((String)this.configuration.getUriEndpointOverride())) {
            return this.configuration.getUriEndpointOverride();
        }
        return null;
    }

    public String getServiceProtocol() {
        return "firehose";
    }

    public Map<String, String> getServiceMetadata() {
        if (this.configuration.getStreamName() != null) {
            return Map.of("stream", this.configuration.getStreamName());
        }
        return null;
    }
}

