/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.kinesis;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.kinesis.Kinesis2Component;
import org.apache.camel.component.aws2.kinesis.Kinesis2Configuration;
import org.apache.camel.component.aws2.kinesis.Kinesis2Consumer;
import org.apache.camel.component.aws2.kinesis.Kinesis2Producer;
import org.apache.camel.component.aws2.kinesis.client.KinesisClientFactory;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;

@UriEndpoint(firstVersion="3.2.0", scheme="aws2-kinesis", title="AWS Kinesis", syntax="aws2-kinesis:streamName", category={Category.CLOUD, Category.MESSAGING})
public class Kinesis2Endpoint
extends ScheduledPollEndpoint {
    @UriParam
    private Kinesis2Configuration configuration;
    private KinesisClient kinesisClient;

    public Kinesis2Endpoint(String uri, Kinesis2Configuration configuration, Kinesis2Component component) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (!this.configuration.isCborEnabled()) {
            System.setProperty(SdkSystemSetting.CBOR_ENABLED.property(), "false");
        }
        KinesisClient kinesisClient = this.kinesisClient = this.configuration.getAmazonKinesisClient() != null ? this.configuration.getAmazonKinesisClient() : KinesisClientFactory.getKinesisClient(this.configuration).getKinesisClient();
        if ((this.configuration.getIteratorType().equals((Object)ShardIteratorType.AFTER_SEQUENCE_NUMBER) || this.configuration.getIteratorType().equals((Object)ShardIteratorType.AT_SEQUENCE_NUMBER)) && this.configuration.getSequenceNumber().isEmpty()) {
            throw new IllegalArgumentException("Sequence Number must be specified with iterator Types AFTER_SEQUENCE_NUMBER or AT_SEQUENCE_NUMBER");
        }
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getAmazonKinesisClient()) && this.kinesisClient != null) {
            this.kinesisClient.close();
        }
        if (!this.configuration.isCborEnabled()) {
            System.clearProperty(SdkSystemSetting.CBOR_ENABLED.property());
        }
        super.doStop();
    }

    public Producer createProducer() throws Exception {
        return new Kinesis2Producer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        Kinesis2Consumer consumer = new Kinesis2Consumer(this, processor);
        consumer.setSchedulerProperties(this.getSchedulerProperties());
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public KinesisClient getClient() {
        return this.kinesisClient;
    }

    public Kinesis2Configuration getConfiguration() {
        return this.configuration;
    }
}

