/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.iam;

import java.util.Map;
import org.apache.camel.component.aws2.iam.IAM2Configuration;
import org.apache.camel.component.aws2.iam.IAM2Endpoint;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.AbstractHealthCheck;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.model.ListAccessKeysRequest;

public class IAM2HealthCheck
extends AbstractHealthCheck {
    private final IAM2Endpoint endpoint;

    public IAM2HealthCheck(IAM2Endpoint endpoint, String clientId) {
        super("camel", "aws2-iam-client-" + clientId);
        this.endpoint = endpoint;
    }

    protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
        try {
            IAM2Configuration configuration = this.endpoint.getConfiguration();
            if (!IamClient.serviceMetadata().regions().contains(Region.of((String)configuration.getRegion()))) {
                builder.message("The service is not supported in this region");
                builder.down();
                return;
            }
            IamClient client = this.endpoint.getIamClient();
            client.listAccessKeys((ListAccessKeysRequest)ListAccessKeysRequest.builder().maxItems(Integer.valueOf(1)).build());
        }
        catch (SdkClientException e) {
            builder.message(e.getMessage());
            builder.error((Throwable)e);
            builder.down();
        }
        catch (Exception e) {
            builder.error((Throwable)e);
            builder.down();
            return;
        }
        builder.up();
    }
}

