/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.eventbridge;

import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.eventbridge.EventbridgeClientHealthCheck;
import org.apache.camel.component.aws2.eventbridge.EventbridgeConfiguration;
import org.apache.camel.component.aws2.eventbridge.EventbridgeConstants;
import org.apache.camel.component.aws2.eventbridge.EventbridgeProducer;
import org.apache.camel.component.aws2.eventbridge.client.EventbridgeClientFactory;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.impl.health.ComponentsHealthCheckRepository;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.services.eventbridge.EventBridgeClient;

@UriEndpoint(firstVersion="3.6.0", scheme="aws2-eventbridge", title="AWS Eventbridge", syntax="aws2-eventbridge://eventbusNameOrArn", producerOnly=true, category={Category.CLOUD, Category.MANAGEMENT}, headersClass=EventbridgeConstants.class)
public class EventbridgeEndpoint
extends DefaultEndpoint {
    private EventBridgeClient eventbridgeClient;
    private ComponentsHealthCheckRepository healthCheckRepository;
    private EventbridgeClientHealthCheck clientHealthCheck;
    @UriPath(description="Event bus name or ARN")
    @Metadata(required=true)
    private String eventbusNameOrArn;
    @UriParam
    private EventbridgeConfiguration configuration;

    public EventbridgeEndpoint(String uri, Component component, EventbridgeConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new EventbridgeProducer((Endpoint)this);
    }

    public void doStart() throws Exception {
        super.doStart();
        this.eventbridgeClient = this.configuration.getEventbridgeClient() != null ? this.configuration.getEventbridgeClient() : EventbridgeClientFactory.getEventbridgeClient(this.configuration).getEventbridgeClient();
        this.healthCheckRepository = (ComponentsHealthCheckRepository)HealthCheckHelper.getHealthCheckRepository((CamelContext)this.getCamelContext(), (String)"components", ComponentsHealthCheckRepository.class);
        if (this.healthCheckRepository != null) {
            this.clientHealthCheck = new EventbridgeClientHealthCheck(this, this.getId());
            this.healthCheckRepository.addHealthCheck((HealthCheck)this.clientHealthCheck);
        }
    }

    public void doStop() throws Exception {
        if (this.healthCheckRepository != null && this.clientHealthCheck != null) {
            this.healthCheckRepository.removeHealthCheck((HealthCheck)this.clientHealthCheck);
            this.clientHealthCheck = null;
        }
        if (ObjectHelper.isEmpty((Object)this.configuration.getEventbridgeClient()) && this.eventbridgeClient != null) {
            this.eventbridgeClient.close();
        }
        super.doStop();
    }

    public EventbridgeConfiguration getConfiguration() {
        return this.configuration;
    }

    public EventBridgeClient getEventbridgeClient() {
        return this.eventbridgeClient;
    }
}

