/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.eks;

import java.util.Map;
import org.apache.camel.component.aws2.eks.EKS2Configuration;
import org.apache.camel.component.aws2.eks.EKS2Endpoint;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.AbstractHealthCheck;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.eks.EksClient;
import software.amazon.awssdk.services.eks.model.ListClustersRequest;

public class EKS2ClientHealthCheck
extends AbstractHealthCheck {
    private final EKS2Endpoint eks2Endpoint;
    private final String clientId;

    public EKS2ClientHealthCheck(EKS2Endpoint eks2Endpoint, String clientId) {
        super("camel", "aws2-eks-client-" + clientId);
        this.eks2Endpoint = eks2Endpoint;
        this.clientId = clientId;
    }

    public boolean isLiveness() {
        return false;
    }

    protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
        EKS2Configuration configuration = this.eks2Endpoint.getConfiguration();
        if (ObjectHelper.isNotEmpty((String)configuration.getRegion()) && !EksClient.serviceMetadata().regions().contains(Region.of((String)configuration.getRegion()))) {
            builder.message("The service is not supported in this region");
            builder.down();
            return;
        }
        try {
            EksClient eks2Client = this.eks2Endpoint.getEksClient();
            eks2Client.listClusters((ListClustersRequest)ListClustersRequest.builder().maxResults(Integer.valueOf(1)).build());
        }
        catch (AwsServiceException e) {
            builder.message(e.getMessage());
            builder.error((Throwable)e);
            if (ObjectHelper.isNotEmpty((Object)e.statusCode())) {
                builder.detail("service.status.code", (Object)e.statusCode());
            }
            if (ObjectHelper.isNotEmpty((String)e.awsErrorDetails().errorCode())) {
                builder.detail("service.error.code", (Object)e.awsErrorDetails().errorCode());
            }
            builder.down();
            return;
        }
        catch (Exception e) {
            builder.error((Throwable)e);
            builder.down();
            return;
        }
        builder.up();
    }
}

