/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.eks;

import org.apache.camel.CamelContext;
import org.apache.camel.component.aws2.eks.EKS2Component;
import org.apache.camel.component.aws2.eks.EKS2Configuration;
import org.apache.camel.component.aws2.eks.EKS2Operations;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.eks.EksClient;

public class EKS2ComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private EKS2Configuration getOrCreateConfiguration(EKS2Component target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new EKS2Configuration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        EKS2Component target = (EKS2Component)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                this.getOrCreateConfiguration(target).setAccessKey((String)EKS2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled((Boolean)EKS2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((EKS2Configuration)EKS2ComponentConfigurer.property((CamelContext)camelContext, EKS2Configuration.class, (Object)value));
                return true;
            }
            case "eksclient": 
            case "eksClient": {
                this.getOrCreateConfiguration(target).setEksClient((EksClient)EKS2ComponentConfigurer.property((CamelContext)camelContext, EksClient.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)EKS2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "operation": {
                this.getOrCreateConfiguration(target).setOperation((EKS2Operations)((Object)EKS2ComponentConfigurer.property((CamelContext)camelContext, EKS2Operations.class, (Object)value)));
                return true;
            }
            case "overrideendpoint": 
            case "overrideEndpoint": {
                this.getOrCreateConfiguration(target).setOverrideEndpoint((Boolean)EKS2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pojorequest": 
            case "pojoRequest": {
                this.getOrCreateConfiguration(target).setPojoRequest((Boolean)EKS2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "proxyhost": 
            case "proxyHost": {
                this.getOrCreateConfiguration(target).setProxyHost((String)EKS2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": 
            case "proxyPort": {
                this.getOrCreateConfiguration(target).setProxyPort((Integer)EKS2ComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                this.getOrCreateConfiguration(target).setProxyProtocol((Protocol)EKS2ComponentConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "region": {
                this.getOrCreateConfiguration(target).setRegion((String)EKS2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": 
            case "secretKey": {
                this.getOrCreateConfiguration(target).setSecretKey((String)EKS2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "trustallcertificates": 
            case "trustAllCertificates": {
                this.getOrCreateConfiguration(target).setTrustAllCertificates((Boolean)EKS2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "uriendpointoverride": 
            case "uriEndpointOverride": {
                this.getOrCreateConfiguration(target).setUriEndpointOverride((String)EKS2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "usedefaultcredentialsprovider": 
            case "useDefaultCredentialsProvider": {
                this.getOrCreateConfiguration(target).setUseDefaultCredentialsProvider((Boolean)EKS2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    public String[] getAutowiredNames() {
        return new String[]{"eksClient"};
    }

    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return String.class;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "configuration": {
                return EKS2Configuration.class;
            }
            case "eksclient": 
            case "eksClient": {
                return EksClient.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "operation": {
                return EKS2Operations.class;
            }
            case "overrideendpoint": 
            case "overrideEndpoint": {
                return Boolean.TYPE;
            }
            case "pojorequest": 
            case "pojoRequest": {
                return Boolean.TYPE;
            }
            case "proxyhost": 
            case "proxyHost": {
                return String.class;
            }
            case "proxyport": 
            case "proxyPort": {
                return Integer.class;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return Protocol.class;
            }
            case "region": {
                return String.class;
            }
            case "secretkey": 
            case "secretKey": {
                return String.class;
            }
            case "trustallcertificates": 
            case "trustAllCertificates": {
                return Boolean.TYPE;
            }
            case "uriendpointoverride": 
            case "uriEndpointOverride": {
                return String.class;
            }
            case "usedefaultcredentialsprovider": 
            case "useDefaultCredentialsProvider": {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        EKS2Component target = (EKS2Component)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return this.getOrCreateConfiguration(target).getAccessKey();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "eksclient": 
            case "eksClient": {
                return this.getOrCreateConfiguration(target).getEksClient();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "operation": {
                return this.getOrCreateConfiguration(target).getOperation();
            }
            case "overrideendpoint": 
            case "overrideEndpoint": {
                return this.getOrCreateConfiguration(target).isOverrideEndpoint();
            }
            case "pojorequest": 
            case "pojoRequest": {
                return this.getOrCreateConfiguration(target).isPojoRequest();
            }
            case "proxyhost": 
            case "proxyHost": {
                return this.getOrCreateConfiguration(target).getProxyHost();
            }
            case "proxyport": 
            case "proxyPort": {
                return this.getOrCreateConfiguration(target).getProxyPort();
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return this.getOrCreateConfiguration(target).getProxyProtocol();
            }
            case "region": {
                return this.getOrCreateConfiguration(target).getRegion();
            }
            case "secretkey": 
            case "secretKey": {
                return this.getOrCreateConfiguration(target).getSecretKey();
            }
            case "trustallcertificates": 
            case "trustAllCertificates": {
                return this.getOrCreateConfiguration(target).isTrustAllCertificates();
            }
            case "uriendpointoverride": 
            case "uriEndpointOverride": {
                return this.getOrCreateConfiguration(target).getUriEndpointOverride();
            }
            case "usedefaultcredentialsprovider": 
            case "useDefaultCredentialsProvider": {
                return this.getOrCreateConfiguration(target).isUseDefaultCredentialsProvider();
            }
        }
        return null;
    }
}

