/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ddb;

import org.apache.camel.Exchange;
import org.apache.camel.component.aws2.ddb.AbstractDdbCommand;
import org.apache.camel.component.aws2.ddb.Ddb2Configuration;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableRequest;

public class UpdateTableCommand
extends AbstractDdbCommand {
    public UpdateTableCommand(DynamoDbClient ddbClient, Ddb2Configuration configuration, Exchange exchange) {
        super(ddbClient, configuration, exchange);
    }

    @Override
    public void execute() {
        this.ddbClient.updateTable((UpdateTableRequest)UpdateTableRequest.builder().tableName(this.determineTableName()).provisionedThroughput((ProvisionedThroughput)ProvisionedThroughput.builder().readCapacityUnits(this.determineReadCapacity()).writeCapacityUnits(this.determineWriteCapacity()).build()).build());
    }

    private Long determineReadCapacity() {
        Long readCapacity = (Long)this.exchange.getIn().getHeader("CamelAwsDdbReadCapacity", Long.class);
        return readCapacity != null ? readCapacity : this.configuration.getReadCapacity();
    }

    private Long determineWriteCapacity() {
        Long writeCapacity = (Long)this.exchange.getIn().getHeader("CamelAwsDdbWriteCapacity", Long.class);
        return writeCapacity != null ? writeCapacity : this.configuration.getWriteCapacity();
    }
}

