/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ddbstream;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.ddbstream.Ddb2StreamComponent;
import org.apache.camel.component.aws2.ddbstream.Ddb2StreamConfiguration;
import org.apache.camel.component.aws2.ddbstream.Ddb2StreamConsumer;
import org.apache.camel.component.aws2.ddbstream.client.Ddb2StreamClientFactory;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsClient;

@UriEndpoint(firstVersion="3.1.0", scheme="aws2-ddbstream", title="AWS DynamoDB Streams", consumerOnly=true, syntax="aws2-ddbstream:tableName", category={Category.CLOUD, Category.MESSAGING})
public class Ddb2StreamEndpoint
extends ScheduledPollEndpoint {
    @UriParam
    Ddb2StreamConfiguration configuration;
    private DynamoDbStreamsClient ddbStreamClient;

    public Ddb2StreamEndpoint(String uri, Ddb2StreamConfiguration configuration, Ddb2StreamComponent component) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        Ddb2StreamConsumer consumer = new Ddb2StreamConsumer(this, processor);
        consumer.setSchedulerProperties(consumer.getEndpoint().getSchedulerProperties());
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public void doStart() throws Exception {
        super.doStart();
        this.ddbStreamClient = this.configuration.getAmazonDynamoDbStreamsClient() != null ? this.configuration.getAmazonDynamoDbStreamsClient() : Ddb2StreamClientFactory.getDynamoDBStreamClient(this.configuration).getDynamoDBStreamClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getAmazonDynamoDbStreamsClient()) && this.ddbStreamClient != null) {
            this.ddbStreamClient.close();
        }
        super.doStop();
    }

    public Ddb2StreamComponent getComponent() {
        return (Ddb2StreamComponent)super.getComponent();
    }

    public Ddb2StreamConfiguration getConfiguration() {
        return this.configuration;
    }

    public DynamoDbStreamsClient getClient() {
        return this.ddbStreamClient;
    }

    public String toString() {
        return "DdbStreamEndpoint{tableName=" + this.configuration.getTableName() + ", amazonDynamoDbStreamsClient=[redacted], maxResultsPerRequest=" + this.configuration.getMaxResultsPerRequest() + ", streamIteratorType=" + this.configuration.getStreamIteratorType() + ", uri=" + this.getEndpointUri() + "}";
    }
}

