/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ddbstream;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.ddbstream.Ddb2StreamConfiguration;
import org.apache.camel.component.aws2.ddbstream.Ddb2StreamEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.HealthCheckComponent;

@Component(value="aws2-ddbstream")
public class Ddb2StreamComponent
extends HealthCheckComponent {
    @Metadata
    private Ddb2StreamConfiguration configuration = new Ddb2StreamConfiguration();

    public Ddb2StreamComponent() {
        this(null);
    }

    public Ddb2StreamComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining == null || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("Table name must be specified.");
        }
        Ddb2StreamConfiguration configuration = this.configuration != null ? this.configuration.copy() : new Ddb2StreamConfiguration();
        configuration.setTableName(remaining);
        Ddb2StreamEndpoint endpoint = new Ddb2StreamEndpoint(uri, configuration, this);
        this.setProperties((Endpoint)endpoint, parameters);
        if (Boolean.FALSE.equals(configuration.isUseDefaultCredentialsProvider()) && Boolean.FALSE.equals(configuration.isUseProfileCredentialsProvider()) && configuration.getAmazonDynamoDbStreamsClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("useDefaultCredentialsProvider is set to false, useProfileCredentialsProvider is set to false, amazonDDBStreamsClient or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public Ddb2StreamConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Ddb2StreamConfiguration configuration) {
        this.configuration = configuration;
    }
}

