/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ddb;

import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws2.ddb.AbstractDdbCommand;
import org.apache.camel.component.aws2.ddb.Ddb2Configuration;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemResponse;

public class UpdateItemCommand
extends AbstractDdbCommand {
    public UpdateItemCommand(DynamoDbClient ddbClient, Ddb2Configuration configuration, Exchange exchange) {
        super(ddbClient, configuration, exchange);
    }

    @Override
    public void execute() {
        UpdateItemResponse result = this.ddbClient.updateItem((UpdateItemRequest)UpdateItemRequest.builder().tableName(this.determineTableName()).key(this.determineKey()).attributeUpdates(this.determineUpdateValues()).expected(this.determineUpdateCondition()).returnValues(this.determineReturnValues()).build());
        this.addAttributesToResult(result.attributes());
    }

    private Map<String, AttributeValueUpdate> determineUpdateValues() {
        return (Map)this.exchange.getIn().getHeader("CamelAwsDdbUpdateValues", Map.class);
    }
}

