/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ddbstream;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.component.aws2.ddbstream.BigIntComparisons;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.dynamodb.model.Shard;

class ShardList {
    private final Logger log = LoggerFactory.getLogger(ShardList.class);
    private final Map<String, Shard> shards = new HashMap<String, Shard>();

    ShardList() {
    }

    void addAll(Collection<Shard> shards) {
        for (Shard shard : shards) {
            this.add(shard);
        }
    }

    void add(Shard shard) {
        this.shards.put(shard.shardId(), shard);
    }

    Shard nextAfter(Shard previous) {
        for (Shard shard : this.shards.values()) {
            if (!previous.shardId().equals(shard.parentShardId())) continue;
            return shard;
        }
        throw new IllegalStateException("Unable to find the next shard for " + previous + " in " + this.shards);
    }

    Shard first() {
        for (Shard shard : this.shards.values()) {
            if (this.shards.containsKey(shard.parentShardId())) continue;
            return shard;
        }
        throw new IllegalStateException("Unable to find an unparented shard in " + this.shards);
    }

    Shard last() {
        HashMap<String, Shard> shardsByParent = new HashMap<String, Shard>();
        for (Shard shard : this.shards.values()) {
            shardsByParent.put(shard.parentShardId(), shard);
        }
        for (Shard shard : this.shards.values()) {
            if (shardsByParent.containsKey(shard.shardId())) continue;
            return shard;
        }
        throw new IllegalStateException("Unable to find a shard with no children " + this.shards);
    }

    Shard afterSeq(String sequenceNumber) {
        return this.atAfterSeq(sequenceNumber, BigIntComparisons.Conditions.LT);
    }

    Shard atSeq(String sequenceNumber) {
        return this.atAfterSeq(sequenceNumber, BigIntComparisons.Conditions.LTEQ);
    }

    Shard atAfterSeq(String sequenceNumber, BigIntComparisons condition) {
        BigInteger atAfter = new BigInteger(sequenceNumber);
        ArrayList<Shard> sorted = new ArrayList<Shard>();
        sorted.addAll(this.shards.values());
        Collections.sort(sorted, StartingSequenceNumberComparator.INSTANCE);
        for (Shard shard : sorted) {
            BigInteger end;
            if (shard.sequenceNumberRange().endingSequenceNumber() == null || !condition.matches(atAfter, end = new BigInteger(shard.sequenceNumberRange().endingSequenceNumber()))) continue;
            return shard;
        }
        if (this.shards.size() > 0) {
            return (Shard)sorted.get(sorted.size() - 1);
        }
        throw new IllegalStateException("Unable to find a shard with appropriate sequence numbers for " + sequenceNumber + " in " + this.shards);
    }

    void removeOlderThan(Shard removeBefore) {
        String current = removeBefore.parentShardId();
        int removedShards = 0;
        while (current != null) {
            Shard s = this.shards.remove(current);
            if (s == null) {
                current = null;
                continue;
            }
            ++removedShards;
            current = s.parentShardId();
        }
        this.log.trace("removed {} shards from the store, new size is {}", (Object)removedShards, (Object)this.shards.size());
    }

    public String toString() {
        return "ShardList{shards=" + this.shards + '}';
    }

    private static enum StartingSequenceNumberComparator implements Comparator<Shard>
    {
        INSTANCE{

            @Override
            public int compare(Shard o1, Shard o2) {
                BigInteger i1 = new BigInteger(o1.sequenceNumberRange().startingSequenceNumber());
                BigInteger i2 = new BigInteger(o2.sequenceNumberRange().startingSequenceNumber());
                return i1.compareTo(i2);
            }
        };

    }
}

