/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ddb;

import java.time.Duration;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.aws2.ddb.Ddb2Configuration;
import org.apache.camel.component.aws2.ddb.Ddb2Producer;
import org.apache.camel.component.aws2.ddb.client.Ddb2ClientFactory;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.support.task.ForegroundTask;
import org.apache.camel.support.task.Tasks;
import org.apache.camel.support.task.budget.Budgets;
import org.apache.camel.support.task.budget.IterationBudget;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.TableDescription;
import software.amazon.awssdk.services.dynamodb.model.TableStatus;

@UriEndpoint(firstVersion="3.1.0", scheme="aws2-ddb", title="AWS DynamoDB", syntax="aws2-ddb:tableName", producerOnly=true, category={Category.CLOUD, Category.DATABASE, Category.NOSQL})
public class Ddb2Endpoint
extends ScheduledPollEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(Ddb2Endpoint.class);
    @UriParam
    private Ddb2Configuration configuration;
    private DynamoDbClient ddbClient;

    public Ddb2Endpoint(String uri, Component component, Ddb2Configuration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new Ddb2Producer((Endpoint)this);
    }

    public void doStart() throws Exception {
        super.doStart();
        this.ddbClient = this.configuration.getAmazonDDBClient() != null ? this.configuration.getAmazonDDBClient() : Ddb2ClientFactory.getDynamoDBClient(this.configuration).getDynamoDBClient();
        String tableName = this.getConfiguration().getTableName();
        LOG.trace("Querying whether table [{}] already exists...", (Object)tableName);
        if (this.configuration.isEnabledInitialDescribeTable()) {
            try {
                DescribeTableRequest.Builder request = DescribeTableRequest.builder().tableName(tableName);
                TableDescription tableDescription = this.ddbClient.describeTable((DescribeTableRequest)request.build()).table();
                if (!this.isTableActive(tableDescription)) {
                    this.waitForTableToBecomeAvailable(tableName);
                }
                LOG.trace("Table [{}] already exists", (Object)tableName);
                return;
            }
            catch (ResourceNotFoundException e) {
                LOG.trace("Table [{}] doesn't exist yet", (Object)tableName);
                LOG.trace("Creating table [{}]...", (Object)tableName);
                TableDescription tableDescription = this.createTable(tableName);
                if (!this.isTableActive(tableDescription)) {
                    this.waitForTableToBecomeAvailable(tableName);
                }
                LOG.trace("Table [{}] created", (Object)tableName);
            }
        }
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getAmazonDDBClient()) && this.ddbClient != null) {
            this.ddbClient.close();
        }
        super.doStop();
    }

    private TableDescription createTable(String tableName) {
        CreateTableRequest.Builder createTableRequest = CreateTableRequest.builder().tableName(tableName).keySchema(new KeySchemaElement[]{(KeySchemaElement)KeySchemaElement.builder().attributeName(this.configuration.getKeyAttributeName()).keyType(this.configuration.getKeyAttributeType()).build()}).provisionedThroughput((ProvisionedThroughput)ProvisionedThroughput.builder().readCapacityUnits(this.configuration.getReadCapacity()).writeCapacityUnits(this.configuration.getWriteCapacity()).build()).attributeDefinitions(new AttributeDefinition[]{(AttributeDefinition)AttributeDefinition.builder().attributeName(this.configuration.getKeyAttributeName()).attributeType(this.configuration.getKeyScalarType()).build()});
        return this.getDdbClient().createTable((CreateTableRequest)createTableRequest.build()).tableDescription();
    }

    public Ddb2Configuration getConfiguration() {
        return this.configuration;
    }

    public DynamoDbClient getDdbClient() {
        return this.ddbClient;
    }

    private void waitForTableToBecomeAvailable(String tableName) {
        LOG.trace("Waiting for [{}] to become ACTIVE...", (Object)tableName);
        ForegroundTask task = Tasks.foregroundTask().withBudget((IterationBudget)Budgets.iterationTimeBudget().withMaxIterations(-1).withMaxDuration(Duration.ofMinutes(5L)).withInterval(Duration.ofSeconds(5L)).build()).build();
        if (!task.run(this::waitForTable, (Object)tableName)) {
            throw new RuntimeCamelException("Table " + tableName + " never went active");
        }
    }

    private boolean waitForTable(String tableName) {
        block3: {
            try {
                DescribeTableRequest request = (DescribeTableRequest)DescribeTableRequest.builder().tableName(tableName).build();
                TableDescription tableDescription = this.getDdbClient().describeTable(request).table();
                if (this.isTableActive(tableDescription)) {
                    LOG.trace("Table [{}] became active", (Object)tableName);
                    return true;
                }
                LOG.trace("Table [{}] not active yet", (Object)tableName);
            }
            catch (AwsServiceException ase) {
                if (ase.getMessage().contains("ResourceNotFoundException")) break block3;
                throw ase;
            }
        }
        return false;
    }

    private boolean isTableActive(TableDescription tableDescription) {
        return tableDescription.tableStatus().toString().equals(TableStatus.ACTIVE.toString());
    }
}

