/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.cw.client;

import org.apache.camel.component.aws2.cw.Cw2Configuration;
import org.apache.camel.component.aws2.cw.client.Cw2InternalClient;
import org.apache.camel.component.aws2.cw.client.impl.Cw2ClientIAMOptimizedImpl;
import org.apache.camel.component.aws2.cw.client.impl.Cw2ClientIAMProfileOptimizedImpl;
import org.apache.camel.component.aws2.cw.client.impl.Cw2ClientStandardImpl;

public final class Cw2ClientFactory {
    private Cw2ClientFactory() {
    }

    public static Cw2InternalClient getCloudWatchClient(Cw2Configuration configuration) {
        if (Boolean.TRUE.equals(configuration.isUseDefaultCredentialsProvider())) {
            return new Cw2ClientIAMOptimizedImpl(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseProfileCredentialsProvider())) {
            return new Cw2ClientIAMProfileOptimizedImpl(configuration);
        }
        return new Cw2ClientStandardImpl(configuration);
    }
}

