/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.cw;

import java.util.Map;
import org.apache.camel.component.aws2.cw.Cw2Configuration;
import org.apache.camel.component.aws2.cw.Cw2Endpoint;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.AbstractHealthCheck;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.model.ListDashboardsRequest;

public class Cw2ClientHealthCheck
extends AbstractHealthCheck {
    private final Cw2Endpoint cw2Endpoint;
    private final String clientId;

    public Cw2ClientHealthCheck(Cw2Endpoint cw2Endpoint, String clientId) {
        super("camel", "aws2-cw-client-" + clientId);
        this.cw2Endpoint = cw2Endpoint;
        this.clientId = clientId;
    }

    public boolean isLiveness() {
        return false;
    }

    protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
        Cw2Configuration configuration = this.cw2Endpoint.getConfiguration();
        if (ObjectHelper.isNotEmpty((String)configuration.getRegion()) && !CloudWatchClient.serviceMetadata().regions().contains(Region.of((String)configuration.getRegion()))) {
            builder.message("The service is not supported in this region");
            builder.down();
            return;
        }
        try {
            CloudWatchClient cw2Client = this.cw2Endpoint.getCloudWatchClient();
            cw2Client.listDashboards((ListDashboardsRequest)ListDashboardsRequest.builder().build());
        }
        catch (AwsServiceException e) {
            builder.message(e.getMessage());
            builder.error((Throwable)e);
            if (ObjectHelper.isNotEmpty((Object)e.statusCode())) {
                builder.detail("service.status.code", (Object)e.statusCode());
            }
            if (ObjectHelper.isNotEmpty((String)e.awsErrorDetails().errorCode())) {
                builder.detail("service.error.code", (Object)e.awsErrorDetails().errorCode());
            }
            builder.down();
            return;
        }
        catch (Exception e) {
            builder.error((Throwable)e);
            builder.down();
            return;
        }
        builder.up();
    }
}

