/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.cw;

import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.cw.Cw2ClientHealthCheck;
import org.apache.camel.component.aws2.cw.Cw2Configuration;
import org.apache.camel.component.aws2.cw.Cw2Constants;
import org.apache.camel.component.aws2.cw.Cw2Producer;
import org.apache.camel.component.aws2.cw.client.Cw2ClientFactory;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.impl.health.ComponentsHealthCheckRepository;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;

@UriEndpoint(firstVersion="3.1.0", scheme="aws2-cw", title="AWS CloudWatch", syntax="aws2-cw:namespace", producerOnly=true, category={Category.CLOUD, Category.MONITORING}, headersClass=Cw2Constants.class)
public class Cw2Endpoint
extends DefaultEndpoint {
    @UriParam
    private Cw2Configuration configuration;
    private CloudWatchClient cloudWatchClient;
    private ComponentsHealthCheckRepository healthCheckRepository;
    private Cw2ClientHealthCheck clientHealthCheck;

    public Cw2Endpoint(String uri, Component component, Cw2Configuration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new Cw2Producer((Endpoint)this);
    }

    public void doInit() throws Exception {
        super.doInit();
        this.cloudWatchClient = this.configuration.getAmazonCwClient() != null ? this.configuration.getAmazonCwClient() : Cw2ClientFactory.getCloudWatchClient(this.configuration).getCloudWatchClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getAmazonCwClient()) && this.cloudWatchClient != null) {
            this.cloudWatchClient.close();
        }
        super.doStop();
    }

    public void doStart() throws Exception {
        super.doStart();
        this.healthCheckRepository = (ComponentsHealthCheckRepository)HealthCheckHelper.getHealthCheckRepository((CamelContext)this.getCamelContext(), (String)"components", ComponentsHealthCheckRepository.class);
        if (this.healthCheckRepository != null) {
            this.clientHealthCheck = new Cw2ClientHealthCheck(this, this.getId());
            this.healthCheckRepository.addHealthCheck((HealthCheck)this.clientHealthCheck);
        }
    }

    public Cw2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Cw2Configuration configuration) {
        this.configuration = configuration;
    }

    public void setCloudWatchClient(CloudWatchClient cloudWatchClient) {
        this.cloudWatchClient = cloudWatchClient;
    }

    public CloudWatchClient getCloudWatchClient() {
        return this.cloudWatchClient;
    }
}

