/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.athena.client.impl;

import java.net.URI;
import org.apache.camel.component.aws2.athena.Athena2Configuration;
import org.apache.camel.component.aws2.athena.client.Athena2InternalClient;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.services.athena.AthenaClient;
import software.amazon.awssdk.services.athena.AthenaClientBuilder;

public class Athena2ClientIAMProfileOptimizedImpl
implements Athena2InternalClient {
    private static final Logger LOG = LoggerFactory.getLogger(Athena2ClientIAMProfileOptimizedImpl.class);
    private Athena2Configuration configuration;

    public Athena2ClientIAMProfileOptimizedImpl(Athena2Configuration configuration) {
        LOG.trace("Creating an AWS Athena manager using profile credentials.");
        this.configuration = configuration;
    }

    @Override
    public AthenaClient getAthenaClient() {
        AthenaClient client = null;
        AthenaClientBuilder clientBuilder = AthenaClient.builder();
        ProxyConfiguration.Builder proxyConfig = null;
        ApacheHttpClient.Builder httpClientBuilder = null;
        if (ObjectHelper.isNotEmpty((String)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            proxyConfig = ProxyConfiguration.builder();
            URI proxyEndpoint = URI.create(String.valueOf(this.configuration.getProxyProtocol()) + "://" + this.configuration.getProxyHost() + ":" + this.configuration.getProxyPort());
            proxyConfig.endpoint(proxyEndpoint);
            httpClientBuilder = ApacheHttpClient.builder().proxyConfiguration((ProxyConfiguration)proxyConfig.build());
            clientBuilder = (AthenaClientBuilder)clientBuilder.httpClientBuilder((SdkHttpClient.Builder)httpClientBuilder);
        }
        if (this.configuration.getProfileCredentialsName() != null) {
            clientBuilder = (AthenaClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)ProfileCredentialsProvider.create((String)this.configuration.getProfileCredentialsName()));
        }
        client = (AthenaClient)clientBuilder.build();
        return client;
    }
}

