/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.athena.client.impl;

import java.net.URI;
import org.apache.camel.component.aws2.athena.Athena2Configuration;
import org.apache.camel.component.aws2.athena.client.Athena2InternalClient;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.athena.AthenaClient;
import software.amazon.awssdk.services.athena.AthenaClientBuilder;

public class Athena2ClientSessionTokenImpl
implements Athena2InternalClient {
    private static final Logger LOG = LoggerFactory.getLogger(Athena2ClientSessionTokenImpl.class);
    private Athena2Configuration configuration;

    public Athena2ClientSessionTokenImpl(Athena2Configuration configuration) {
        LOG.trace("Creating an AWS Athena manager using static credentials.");
        this.configuration = configuration;
    }

    @Override
    public AthenaClient getAthenaClient() {
        AthenaClient client = null;
        AthenaClientBuilder clientBuilder = AthenaClient.builder();
        ProxyConfiguration.Builder proxyConfig = null;
        ApacheHttpClient.Builder httpClientBuilder = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((String)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            proxyConfig = ProxyConfiguration.builder();
            URI proxyEndpoint = URI.create(this.configuration.getProxyProtocol() + "://" + this.configuration.getProxyHost() + ":" + this.configuration.getProxyPort());
            proxyConfig.endpoint(proxyEndpoint);
            httpClientBuilder = ApacheHttpClient.builder().proxyConfiguration((ProxyConfiguration)proxyConfig.build());
            isClientConfigFound = true;
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null && this.configuration.getSessionToken() != null) {
            AwsSessionCredentials cred = AwsSessionCredentials.create((String)this.configuration.getAccessKey(), (String)this.configuration.getSecretKey(), (String)this.configuration.getSessionToken());
            clientBuilder = isClientConfigFound ? (AthenaClientBuilder)((AthenaClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder)).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred)) : (AthenaClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred));
        } else if (!isClientConfigFound) {
            clientBuilder = (AthenaClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder);
        }
        if (ObjectHelper.isNotEmpty((String)this.configuration.getRegion())) {
            clientBuilder = (AthenaClientBuilder)clientBuilder.region(Region.of((String)this.configuration.getRegion()));
        }
        client = (AthenaClient)clientBuilder.build();
        return client;
    }
}

