/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.athena;

import java.util.Arrays;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.athena.Athena2Configuration;
import org.apache.camel.component.aws2.athena.Athena2Endpoint;
import org.apache.camel.component.aws2.athena.Athena2Operations;
import org.apache.camel.component.aws2.athena.Athena2OutputType;
import org.apache.camel.component.aws2.athena.Athena2QueryHelper;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.athena.AthenaClient;
import software.amazon.awssdk.services.athena.model.EncryptionConfiguration;
import software.amazon.awssdk.services.athena.model.EncryptionOption;
import software.amazon.awssdk.services.athena.model.GetQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.GetQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.GetQueryResultsRequest;
import software.amazon.awssdk.services.athena.model.GetQueryResultsResponse;
import software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest;
import software.amazon.awssdk.services.athena.model.ListQueryExecutionsResponse;
import software.amazon.awssdk.services.athena.model.QueryExecutionContext;
import software.amazon.awssdk.services.athena.model.ResultConfiguration;
import software.amazon.awssdk.services.athena.model.StartQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.StartQueryExecutionResponse;
import software.amazon.awssdk.services.athena.paginators.GetQueryResultsIterable;

public class Athena2Producer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(Athena2Producer.class);

    public Athena2Producer(Endpoint endpoint) {
        super(endpoint);
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }

    public void process(Exchange exchange) throws Exception {
        Athena2Operations operation = this.determineOperation(exchange);
        switch (operation) {
            case getQueryExecution: {
                this.getQueryExecution(this.getEndpoint().getAthenaClient(), exchange);
                break;
            }
            case getQueryResults: {
                this.getQueryResults(this.getEndpoint().getAthenaClient(), exchange);
                break;
            }
            case listQueryExecutions: {
                this.listQueryExecutions(this.getEndpoint().getAthenaClient(), exchange);
                break;
            }
            case startQueryExecution: {
                this.startQueryExecution(this.getEndpoint().getAthenaClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid operation [" + operation + "] specified.  Must be one of " + Arrays.asList(Athena2Operations.values()));
            }
        }
    }

    private Athena2Operations determineOperation(Exchange exchange) {
        Athena2Operations operation = (Athena2Operations)((Object)exchange.getIn().getHeader("CamelAwsAthenaOperation", Athena2Operations.class));
        if (operation == null) {
            Athena2Operations defaultOperation = Athena2Operations.startQueryExecution;
            operation = this.getConfiguration().getOperation() == null ? defaultOperation : this.getConfiguration().getOperation();
        }
        return operation;
    }

    private void getQueryExecution(AthenaClient athenaClient, Exchange exchange) {
        String queryExecutionId = this.determineQueryExecutionId(exchange);
        GetQueryExecutionResponse getQueryExecutionResponse = this.doGetQueryExecution(queryExecutionId, athenaClient);
        Message message = Athena2Producer.getMessageForResponse(exchange);
        message.setHeader("CamelAwsAthenaQueryExecutionId", (Object)getQueryExecutionResponse.queryExecution().queryExecutionId());
        message.setHeader("CamelAwsAthenaQueryExecutionState", (Object)getQueryExecutionResponse.queryExecution().status().state());
        message.setHeader("CamelAwsAthenaOutputLocation", (Object)getQueryExecutionResponse.queryExecution().resultConfiguration().outputLocation());
        message.setBody((Object)getQueryExecutionResponse);
    }

    private GetQueryExecutionResponse doGetQueryExecution(String queryExecutionId, AthenaClient athenaClient) {
        GetQueryExecutionRequest.Builder request = GetQueryExecutionRequest.builder();
        request.queryExecutionId(queryExecutionId);
        return athenaClient.getQueryExecution((GetQueryExecutionRequest)request.build());
    }

    private void getQueryResults(AthenaClient athenaClient, Exchange exchange) {
        String queryExecutionId = this.determineQueryExecutionId(exchange);
        Message message = Athena2Producer.getMessageForResponse(exchange);
        message.setHeader("CamelAwsAthenaQueryExecutionId", (Object)queryExecutionId);
        Athena2OutputType outputType = this.determineOutputType(exchange);
        if (outputType == Athena2OutputType.StreamList) {
            GetQueryResultsRequest request = (GetQueryResultsRequest)this.doGetQueryResultsRequest(queryExecutionId, exchange).build();
            GetQueryResultsIterable response = athenaClient.getQueryResultsPaginator(request);
            message.setBody((Object)response);
        } else if (outputType == Athena2OutputType.SelectList) {
            GetQueryResultsRequest request = (GetQueryResultsRequest)this.doGetQueryResultsRequest(queryExecutionId, exchange).build();
            GetQueryResultsResponse response = athenaClient.getQueryResults(request);
            message.setHeader("CamelAwsAthenaNextToken", (Object)response.nextToken());
            message.setBody((Object)response);
        } else if (outputType == Athena2OutputType.S3Pointer) {
            GetQueryExecutionResponse response = this.doGetQueryExecution(queryExecutionId, athenaClient);
            String outputLocation = response.queryExecution().resultConfiguration().outputLocation();
            message.setHeader("CamelAwsAthenaQueryExecutionState", (Object)response.queryExecution().status().state());
            message.setHeader("CamelAwsAthenaOutputLocation", (Object)response.queryExecution().resultConfiguration().outputLocation());
            message.setBody((Object)outputLocation);
        } else {
            throw new IllegalArgumentException("AWS Athena output type [" + outputType + "] is not supported.  Must be one of " + Arrays.asList(Athena2OutputType.values()));
        }
    }

    private Athena2OutputType determineOutputType(Exchange exchange) {
        Athena2OutputType outputType = (Athena2OutputType)((Object)exchange.getIn().getHeader("CamelAwsAthenaOutputType", Athena2OutputType.class));
        if (ObjectHelper.isEmpty((Object)((Object)outputType))) {
            outputType = this.getConfiguration().getOutputType();
            LOG.trace("AWS Athena output type is missing, using default one [{}]", (Object)outputType);
        }
        return outputType;
    }

    private GetQueryResultsRequest.Builder doGetQueryResultsRequest(String queryExecutionId, Exchange exchange) {
        GetQueryResultsRequest.Builder request = GetQueryResultsRequest.builder();
        request.queryExecutionId(queryExecutionId);
        Integer maxResults = this.determineMaxResults(exchange);
        request.maxResults(maxResults);
        String nextToken = this.determineNextToken(exchange);
        request.nextToken(nextToken);
        return request;
    }

    private void listQueryExecutions(AthenaClient athenaClient, Exchange exchange) {
        ListQueryExecutionsRequest.Builder request = ListQueryExecutionsRequest.builder();
        Integer maxResults = this.determineMaxResults(exchange);
        request.maxResults(maxResults);
        String nextToken = this.determineNextToken(exchange);
        request.nextToken(nextToken);
        String workGroup = this.determineWorkGroup(exchange);
        request.workGroup(workGroup);
        ListQueryExecutionsResponse response = athenaClient.listQueryExecutions((ListQueryExecutionsRequest)request.build());
        Message message = Athena2Producer.getMessageForResponse(exchange);
        message.setHeader("CamelAwsAthenaNextToken", (Object)response.nextToken());
        message.setBody((Object)response);
    }

    private void startQueryExecution(AthenaClient athenaClient, Exchange exchange) {
        GetQueryExecutionResponse getQueryExecutionResponse = null;
        Athena2QueryHelper athena2QueryHelper = new Athena2QueryHelper(exchange, this.getConfiguration());
        String queryExecutionId = null;
        while (athena2QueryHelper.shouldAttempt()) {
            queryExecutionId = this.doStartQueryExecution(athenaClient, exchange).queryExecutionId();
            athena2QueryHelper.markAttempt();
            while (athena2QueryHelper.shouldWait()) {
                athena2QueryHelper.doWait();
                getQueryExecutionResponse = this.doGetQueryExecution(queryExecutionId, athenaClient);
                athena2QueryHelper.setStatusFrom(getQueryExecutionResponse);
            }
        }
        Message message = Athena2Producer.getMessageForResponse(exchange);
        message.setHeader("CamelAwsAthenaQueryExecutionId", (Object)queryExecutionId);
        message.setHeader("CamelAwsAthenaQueryExecutionState", getQueryExecutionResponse == null ? null : getQueryExecutionResponse.queryExecution().status().state());
        message.setHeader("CamelAwsAthenaOutputLocation", getQueryExecutionResponse == null ? null : getQueryExecutionResponse.queryExecution().resultConfiguration().outputLocation());
        message.setHeader("CamelAwsAthenaStartQueryExecutionAttempts", (Object)athena2QueryHelper.getAttempts());
        message.setHeader("CamelAwsAthenaStartQueryExecutionElapsedMillis", (Object)athena2QueryHelper.getElapsedMillis());
        message.setBody((Object)getQueryExecutionResponse);
    }

    private StartQueryExecutionResponse doStartQueryExecution(AthenaClient athenaClient, Exchange exchange) {
        String database;
        StartQueryExecutionRequest.Builder request = StartQueryExecutionRequest.builder();
        String clientRequestToken = this.determineClientRequestToken(exchange);
        if (ObjectHelper.isNotEmpty((String)clientRequestToken)) {
            request.clientRequestToken(clientRequestToken);
        }
        if (ObjectHelper.isNotEmpty((String)(database = this.determineDatabase(exchange)))) {
            QueryExecutionContext.Builder queryExecutionContext = QueryExecutionContext.builder();
            queryExecutionContext.database(database);
            request.queryExecutionContext((QueryExecutionContext)queryExecutionContext.build());
        }
        String queryString = this.determineQueryString(exchange);
        request.queryString(queryString);
        ResultConfiguration.Builder resultConfiguration = ResultConfiguration.builder();
        EncryptionOption encryptionOption = this.determineEncryptionOption(exchange);
        String kmsKey = this.determineKmsKey(exchange);
        if (ObjectHelper.isNotEmpty((Object)encryptionOption) || ObjectHelper.isNotEmpty((String)kmsKey)) {
            if (ObjectHelper.isEmpty((Object)encryptionOption)) {
                throw new IllegalArgumentException("AWS Athena encryption option is required when setting KMS key.");
            }
            EncryptionConfiguration.Builder encryptionConfiguration = EncryptionConfiguration.builder();
            encryptionConfiguration.encryptionOption(encryptionOption);
            encryptionConfiguration.kmsKey(kmsKey);
            resultConfiguration.encryptionConfiguration((EncryptionConfiguration)encryptionConfiguration.build());
        }
        String outputLocation = this.determineOutputLocation(exchange);
        resultConfiguration.outputLocation(outputLocation);
        request.resultConfiguration((ResultConfiguration)resultConfiguration.build());
        String workGroup = this.determineWorkGroup(exchange);
        if (ObjectHelper.isNotEmpty((String)workGroup)) {
            request.workGroup(workGroup);
        }
        StartQueryExecutionResponse response = athenaClient.startQueryExecution((StartQueryExecutionRequest)request.build());
        if (LOG.isTraceEnabled()) {
            LOG.trace("AWS Athena startQueryExecution successful, queryExecutionId={}", (Object)response.queryExecutionId());
        }
        return response;
    }

    private String determineQueryExecutionId(Exchange exchange) {
        String queryExecutionId = (String)exchange.getIn().getHeader("CamelAwsAthenaQueryExecutionId", String.class);
        if (ObjectHelper.isEmpty((String)queryExecutionId)) {
            queryExecutionId = this.getConfiguration().getQueryExecutionId();
        }
        if (ObjectHelper.isEmpty((String)queryExecutionId)) {
            throw new IllegalArgumentException("AWS Athena query execution id is required.");
        }
        return queryExecutionId;
    }

    private Integer determineMaxResults(Exchange exchange) {
        Integer maxResults = (Integer)exchange.getIn().getHeader("CamelAwsAthenaMaxResults", Integer.class);
        if (ObjectHelper.isEmpty((Object)maxResults)) {
            maxResults = this.getConfiguration().getMaxResults();
            LOG.trace("AWS Athena max results is missing, using default one [{}]", (Object)maxResults);
        }
        return maxResults;
    }

    private boolean determineIncludeTrace(Exchange exchange) {
        Boolean includeTrace = (Boolean)exchange.getIn().getHeader("CamelAwsAthenaIncludeTrace", Boolean.class);
        if (ObjectHelper.isEmpty((Object)includeTrace)) {
            includeTrace = this.getConfiguration().isIncludeTrace();
            LOG.trace("AWS Athena include trace is missing, using default one [{}]", (Object)includeTrace);
        }
        return includeTrace;
    }

    private String determineNextToken(Exchange exchange) {
        String nextToken = (String)exchange.getIn().getHeader("CamelAwsAthenaNextToken", String.class);
        if (ObjectHelper.isEmpty((String)nextToken)) {
            nextToken = this.getConfiguration().getNextToken();
            LOG.trace("AWS Athena next token is missing, using default one [{}]", (Object)nextToken);
        }
        return nextToken;
    }

    private String determineClientRequestToken(Exchange exchange) {
        String clientRequestToken = (String)exchange.getIn().getHeader("CamelAwsAthenaClientRequestToken", String.class);
        if (ObjectHelper.isEmpty((String)clientRequestToken)) {
            clientRequestToken = this.getConfiguration().getClientRequestToken();
            LOG.trace("AWS Athena client request token is missing, using default one [{}]", (Object)clientRequestToken);
        }
        return clientRequestToken;
    }

    private String determineDatabase(Exchange exchange) {
        String database = (String)exchange.getIn().getHeader("CamelAwsAthenaDatabase", String.class);
        if (ObjectHelper.isEmpty((String)database)) {
            database = this.getConfiguration().getDatabase();
            LOG.trace("AWS Athena database is missing, using default one [{}]", (Object)database);
        }
        return database;
    }

    private String determineQueryString(Exchange exchange) {
        Object queryString = (String)exchange.getIn().getBody(String.class);
        if (ObjectHelper.isEmpty((String)queryString)) {
            queryString = (String)exchange.getIn().getHeader("CamelAwsAthenaQueryString", String.class);
        }
        if (ObjectHelper.isEmpty((String)queryString)) {
            queryString = this.getConfiguration().getQueryString();
        }
        if (ObjectHelper.isEmpty((String)queryString)) {
            throw new IllegalArgumentException("AWS Athena query string is required.");
        }
        boolean includeTrace = this.determineIncludeTrace(exchange);
        if (includeTrace) {
            queryString = "-- {\"fromEndpointUri\": \"" + exchange.getFromEndpoint().getEndpointUri() + "\", \"exchangeId\": \"" + exchange.getExchangeId() + "\", \"exchangeFromRouteId\": \"" + exchange.getFromRouteId() + "\"}\n" + (String)queryString;
        }
        return queryString;
    }

    private EncryptionOption determineEncryptionOption(Exchange exchange) {
        EncryptionOption encryptionOption = (EncryptionOption)exchange.getIn().getHeader("CamelAwsAthenaEncryptionOption", EncryptionOption.class);
        if (ObjectHelper.isEmpty((Object)encryptionOption)) {
            encryptionOption = this.getConfiguration().getEncryptionOption();
            LOG.trace("AWS Athena encryption option is missing, using default one [{}]", (Object)encryptionOption);
        }
        return encryptionOption;
    }

    private String determineKmsKey(Exchange exchange) {
        String kmsKey = (String)exchange.getIn().getHeader("CamelAwsAthenaKmsKey", String.class);
        if (ObjectHelper.isEmpty((String)kmsKey)) {
            kmsKey = this.getConfiguration().getKmsKey();
            LOG.trace("AWS Athena kms key is missing, using default one [{}]", (Object)kmsKey);
        }
        return kmsKey;
    }

    private String determineOutputLocation(Exchange exchange) {
        String outputLocation = (String)exchange.getIn().getHeader("CamelAwsAthenaOutputLocation", String.class);
        if (ObjectHelper.isEmpty((String)outputLocation)) {
            outputLocation = this.getConfiguration().getOutputLocation();
        }
        if (ObjectHelper.isEmpty((String)outputLocation)) {
            throw new IllegalArgumentException("AWS Athena output location is required.");
        }
        return outputLocation;
    }

    private String determineWorkGroup(Exchange exchange) {
        String workGroup = (String)exchange.getIn().getHeader("CamelAwsAthenaWorkGroup", String.class);
        if (ObjectHelper.isEmpty((String)workGroup)) {
            workGroup = this.getConfiguration().getWorkGroup();
            LOG.trace("AWS Athena work group is missing, using default one [{}]", (Object)workGroup);
        }
        return workGroup;
    }

    protected Athena2Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public Athena2Endpoint getEndpoint() {
        return (Athena2Endpoint)super.getEndpoint();
    }
}

