/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.athena;

import java.util.Map;
import org.apache.camel.component.aws2.athena.Athena2Endpoint;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.AbstractHealthCheck;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.athena.AthenaClient;
import software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest;

public class Athena2ClientHealthCheck
extends AbstractHealthCheck {
    private final Athena2Endpoint athena2Endpoint;
    private final String clientId;

    public Athena2ClientHealthCheck(Athena2Endpoint athena2Endpoint, String clientId) {
        super("camel", "aws2-athena-client-" + clientId);
        this.athena2Endpoint = athena2Endpoint;
        this.clientId = clientId;
    }

    public boolean isLiveness() {
        return false;
    }

    protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
        try {
            if (ObjectHelper.isNotEmpty((String)this.athena2Endpoint.getConfiguration().getRegion()) && !AthenaClient.serviceMetadata().regions().contains(Region.of((String)this.athena2Endpoint.getConfiguration().getRegion()))) {
                builder.message("The service is not supported in this region");
                builder.down();
                return;
            }
            AthenaClient client = this.athena2Endpoint.getAthenaClient();
            client.listQueryExecutions((ListQueryExecutionsRequest)ListQueryExecutionsRequest.builder().maxResults(Integer.valueOf(1)).build());
        }
        catch (AwsServiceException e) {
            builder.message(e.getMessage());
            builder.error((Throwable)e);
            if (ObjectHelper.isNotEmpty((Object)e.statusCode())) {
                builder.detail("service.status.code", (Object)e.statusCode());
            }
            if (ObjectHelper.isNotEmpty((String)e.awsErrorDetails().errorCode())) {
                builder.detail("service.error.code", (Object)e.awsErrorDetails().errorCode());
            }
            builder.down();
            return;
        }
        catch (Exception e) {
            builder.error((Throwable)e);
            builder.down();
            return;
        }
        builder.up();
    }
}

