/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ec2;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.ec2.AmazonEC2Client;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws.ec2.EC2Configuration;
import org.apache.camel.component.aws.ec2.EC2Producer;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(scheme="aws-ec2", title="AWS EC2", syntax="aws-ec2:label", producerOnly=true, label="cloud,management")
public class EC2Endpoint
extends ScheduledPollEndpoint {
    private AmazonEC2Client ec2Client;
    @UriParam
    private EC2Configuration configuration;

    public EC2Endpoint(String uri, Component component, EC2Configuration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new EC2Producer((Endpoint)this);
    }

    public boolean isSingleton() {
        return true;
    }

    public void doStart() throws Exception {
        super.doStart();
        AmazonEC2Client amazonEC2Client = this.ec2Client = this.configuration.getAmazonEc2Client() != null ? this.configuration.getAmazonEc2Client() : this.createEc2Client();
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getAmazonEc2Endpoint())) {
            this.ec2Client.setEndpoint(this.configuration.getAmazonEc2Endpoint());
        }
    }

    public EC2Configuration getConfiguration() {
        return this.configuration;
    }

    public AmazonEC2Client getEc2Client() {
        return this.ec2Client;
    }

    AmazonEC2Client createEc2Client() {
        AmazonEC2Client client = null;
        BasicAWSCredentials credentials = new BasicAWSCredentials(this.configuration.getAccessKey(), this.configuration.getSecretKey());
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            ClientConfiguration clientConfiguration = new ClientConfiguration();
            clientConfiguration.setProxyHost(this.configuration.getProxyHost());
            clientConfiguration.setProxyPort(this.configuration.getProxyPort().intValue());
            client = new AmazonEC2Client((AWSCredentials)credentials, clientConfiguration);
        } else {
            client = new AmazonEC2Client((AWSCredentials)credentials);
        }
        return client;
    }
}

