/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.xray.decorators;

import com.amazonaws.xray.entities.Entity;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws.xray.decorators.AbstractSegmentDecorator;

public class ElasticsearchSegmentDecorator
extends AbstractSegmentDecorator {
    public static final String ELASTICSARCH_DB_TYPE = "elasticsearch";
    public static final String ELASTICSEARCH_CLUSTER_TAG = "elasticsearch.cluster";

    @Override
    public String getComponent() {
        return ELASTICSARCH_DB_TYPE;
    }

    @Override
    public String getOperationName(Exchange exchange, Endpoint endpoint) {
        Map<String, String> queryParameters = ElasticsearchSegmentDecorator.toQueryParameters(endpoint.getEndpointUri());
        return queryParameters.containsKey("operation") ? queryParameters.get("operation") : super.getOperationName(exchange, endpoint);
    }

    @Override
    public void pre(Entity segment, Exchange exchange, Endpoint endpoint) {
        String cluster;
        super.pre(segment, exchange, endpoint);
        segment.putMetadata("db.type", (Object)ELASTICSARCH_DB_TYPE);
        Map<String, String> queryParameters = ElasticsearchSegmentDecorator.toQueryParameters(endpoint.getEndpointUri());
        if (queryParameters.containsKey("indexName")) {
            segment.putMetadata("db.instance", (Object)queryParameters.get("indexName"));
        }
        if (null != (cluster = ElasticsearchSegmentDecorator.stripSchemeAndOptions(endpoint))) {
            segment.putMetadata(ELASTICSEARCH_CLUSTER_TAG, (Object)cluster);
        }
    }
}

