/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.xray.decorators.http;

import com.amazonaws.xray.entities.Entity;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws.xray.decorators.http.AbstractHttpSegmentDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestSegmentDecorator
extends AbstractHttpSegmentDecorator {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public String getComponent() {
        return "rest";
    }

    @Override
    public String getOperationName(Exchange exchange, Endpoint endpoint) {
        return RestSegmentDecorator.getPath(endpoint.getEndpointUri());
    }

    @Override
    public void pre(Entity segment, Exchange exchange, Endpoint endpoint) {
        super.pre(segment, exchange, endpoint);
        RestSegmentDecorator.getParameters(RestSegmentDecorator.getPath(endpoint.getEndpointUri())).forEach(param -> {
            Object value = exchange.getIn().getHeader(param);
            if (value != null) {
                segment.putMetadata(param, value);
            }
        });
    }

    protected static String getPath(String uri) {
        String path = null;
        int index = uri.indexOf(58);
        if (index != -1 && (index = uri.indexOf(58, index + 1)) != -1) {
            path = uri.substring(index + 1);
            if ((index = path.indexOf(63)) != -1) {
                path = path.substring(0, index);
            }
            path = path.replace(":", "");
            try {
                path = URLDecoder.decode(path, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOG.debug("Failed to decode URL path '" + path + "', ignoring exception", (Throwable)e);
            }
        }
        return path;
    }

    protected static List<String> getParameters(String path) {
        ArrayList<String> parameters = null;
        int startIndex = path.indexOf(123);
        while (startIndex != -1) {
            int endIndex = path.indexOf(125, startIndex);
            if (endIndex != -1) {
                if (parameters == null) {
                    parameters = new ArrayList<String>();
                }
                parameters.add(path.substring(startIndex + 1, endIndex));
                startIndex = path.indexOf(123, endIndex);
                continue;
            }
            startIndex = -1;
        }
        return parameters == null ? Collections.emptyList() : parameters;
    }
}

