/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.secretsmanager.client.impl;

import java.net.URI;
import org.apache.camel.component.aws.secretsmanager.SecretsManagerConfiguration;
import org.apache.camel.component.aws.secretsmanager.client.SecretsManagerInternalClient;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.utils.AttributeMap;

public class SecretsManagerClientIAMProfileOptimized
implements SecretsManagerInternalClient {
    private static final Logger LOG = LoggerFactory.getLogger(SecretsManagerClientIAMProfileOptimized.class);
    private SecretsManagerConfiguration configuration;

    public SecretsManagerClientIAMProfileOptimized(SecretsManagerConfiguration configuration) {
        LOG.trace("Creating an AWS Secrets Manager client for working on AWS Services");
        this.configuration = configuration;
    }

    @Override
    public SecretsManagerClient getSecretsManagerClient() {
        SecretsManagerClient client = null;
        SecretsManagerClientBuilder clientBuilder = SecretsManagerClient.builder();
        ProxyConfiguration.Builder proxyConfig = null;
        ApacheHttpClient.Builder httpClientBuilder = null;
        if (ObjectHelper.isNotEmpty((String)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            proxyConfig = ProxyConfiguration.builder();
            URI proxyEndpoint = URI.create(String.valueOf(this.configuration.getProxyProtocol()) + "://" + this.configuration.getProxyHost() + ":" + this.configuration.getProxyPort());
            proxyConfig.endpoint(proxyEndpoint);
            httpClientBuilder = ApacheHttpClient.builder().proxyConfiguration((ProxyConfiguration)proxyConfig.build());
            clientBuilder = (SecretsManagerClientBuilder)clientBuilder.httpClientBuilder((SdkHttpClient.Builder)httpClientBuilder);
        }
        if (this.configuration.getProfileCredentialsName() != null) {
            clientBuilder = (SecretsManagerClientBuilder)((SecretsManagerClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder)).credentialsProvider((AwsCredentialsProvider)ProfileCredentialsProvider.create((String)this.configuration.getProfileCredentialsName()));
        }
        if (ObjectHelper.isNotEmpty((String)this.configuration.getRegion())) {
            clientBuilder = (SecretsManagerClientBuilder)clientBuilder.region(Region.of((String)this.configuration.getRegion()));
        }
        if (this.configuration.isOverrideEndpoint()) {
            clientBuilder.endpointOverride(URI.create(this.configuration.getUriEndpointOverride()));
        }
        if (this.configuration.isTrustAllCertificates()) {
            if (httpClientBuilder == null) {
                httpClientBuilder = ApacheHttpClient.builder();
            }
            SdkHttpClient ahc = httpClientBuilder.buildWithDefaults(AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES, (Object)Boolean.TRUE).build());
            clientBuilder.httpClient(ahc);
            clientBuilder.httpClientBuilder(null);
        }
        client = (SecretsManagerClient)clientBuilder.build();
        return client;
    }
}

