/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.secretsmanager;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.Base64;
import java.util.HashSet;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.annotations.PropertiesFunction;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.vault.AwsVaultConfiguration;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;
import software.amazon.awssdk.services.secretsmanager.model.SecretsManagerException;

@PropertiesFunction(value="aws")
public class SecretsManagerPropertiesFunction
extends ServiceSupport
implements org.apache.camel.spi.PropertiesFunction,
CamelContextAware {
    private static final String CAMEL_AWS_VAULT_ACCESS_KEY_ENV = "CAMEL_VAULT_AWS_ACCESS_KEY";
    private static final String CAMEL_AWS_VAULT_SECRET_KEY_ENV = "CAMEL_VAULT_AWS_SECRET_KEY";
    private static final String CAMEL_AWS_VAULT_REGION_ENV = "CAMEL_VAULT_AWS_REGION";
    private static final String CAMEL_AWS_VAULT_USE_DEFAULT_CREDENTIALS_PROVIDER_ENV = "CAMEL_VAULT_AWS_USE_DEFAULT_CREDENTIALS_PROVIDER";
    private static final String CAMEL_AWS_VAULT_USE_PROFILE_CREDENTIALS_PROVIDER_ENV = "CAMEL_VAULT_AWS_USE_PROFILE_CREDENTIALS_PROVIDER";
    private static final String CAMEL_AWS_VAULT_PROFILE_NAME_ENV = "CAMEL_AWS_VAULT_PROFILE_NAME";
    private static final String CAMEL_AWS_VAULT_IS_OVERRIDE_ENDPOINT = "CAMEL_AWS_VAULT_IS_OVERRIDE_ENDPOINT";
    private static final String CAMEL_AWS_VAULT_URI_ENDPOINT_OVERRIDE = "CAMEL_AWS_VAULT_URI_ENDPOINT_OVERRIDE";
    private CamelContext camelContext;
    private SecretsManagerClient client;
    private final Set<String> secrets = new HashSet<String>();
    private String region;
    private boolean defaultCredentialsProvider;
    private boolean profleCredentialsProvider;
    private String profileName;
    private boolean isOverrideEndpoint;
    private String uriEndpointOverride;

    public SecretsManagerPropertiesFunction() {
    }

    public SecretsManagerPropertiesFunction(SecretsManagerClient client) {
        this.client = client;
    }

    protected void doStart() throws Exception {
        AwsVaultConfiguration awsVaultConfiguration;
        super.doStart();
        String accessKey = System.getenv(CAMEL_AWS_VAULT_ACCESS_KEY_ENV);
        String secretKey = System.getenv(CAMEL_AWS_VAULT_SECRET_KEY_ENV);
        String region = System.getenv(CAMEL_AWS_VAULT_REGION_ENV);
        boolean useDefaultCredentialsProvider = Boolean.parseBoolean(System.getenv(CAMEL_AWS_VAULT_USE_DEFAULT_CREDENTIALS_PROVIDER_ENV));
        boolean useProfileCredentialsProvider = Boolean.parseBoolean(System.getenv(CAMEL_AWS_VAULT_USE_PROFILE_CREDENTIALS_PROVIDER_ENV));
        String profileName = System.getenv(CAMEL_AWS_VAULT_PROFILE_NAME_ENV);
        boolean isOverrideEndpoint = Boolean.parseBoolean(System.getenv(CAMEL_AWS_VAULT_IS_OVERRIDE_ENDPOINT));
        String uriEndpointOverride = System.getenv(CAMEL_AWS_VAULT_URI_ENDPOINT_OVERRIDE);
        if (ObjectHelper.isEmpty((String)accessKey) && ObjectHelper.isEmpty((String)secretKey) && ObjectHelper.isEmpty((String)region) && ObjectHelper.isNotEmpty((Object)(awsVaultConfiguration = this.getCamelContext().getVaultConfiguration().aws()))) {
            accessKey = awsVaultConfiguration.getAccessKey();
            secretKey = awsVaultConfiguration.getSecretKey();
            region = awsVaultConfiguration.getRegion();
            useDefaultCredentialsProvider = awsVaultConfiguration.isDefaultCredentialsProvider();
            useProfileCredentialsProvider = awsVaultConfiguration.isProfileCredentialsProvider();
            profileName = awsVaultConfiguration.getProfileName();
            isOverrideEndpoint = awsVaultConfiguration.isOverrideEndpoint();
            uriEndpointOverride = awsVaultConfiguration.getUriEndpointOverride();
        }
        this.region = region;
        if (ObjectHelper.isNotEmpty((String)accessKey) && ObjectHelper.isNotEmpty((String)secretKey) && ObjectHelper.isNotEmpty((String)region)) {
            clientBuilder = SecretsManagerClient.builder();
            AwsBasicCredentials cred = AwsBasicCredentials.create((String)accessKey, (String)secretKey);
            clientBuilder = (SecretsManagerClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred));
            clientBuilder.region(Region.of((String)region));
            if (isOverrideEndpoint && ObjectHelper.isNotEmpty((String)uriEndpointOverride)) {
                clientBuilder.endpointOverride(URI.create(uriEndpointOverride));
            }
            this.client = (SecretsManagerClient)clientBuilder.build();
        } else if (useDefaultCredentialsProvider && ObjectHelper.isNotEmpty((String)region)) {
            this.defaultCredentialsProvider = true;
            clientBuilder = SecretsManagerClient.builder();
            clientBuilder.region(Region.of((String)region));
            if (isOverrideEndpoint && ObjectHelper.isNotEmpty((String)uriEndpointOverride)) {
                clientBuilder.endpointOverride(URI.create(uriEndpointOverride));
            }
            this.client = (SecretsManagerClient)clientBuilder.build();
        } else if (useProfileCredentialsProvider && ObjectHelper.isNotEmpty((String)profileName)) {
            this.profleCredentialsProvider = true;
            this.profileName = profileName;
            clientBuilder = SecretsManagerClient.builder();
            clientBuilder.credentialsProvider((AwsCredentialsProvider)ProfileCredentialsProvider.create((String)profileName));
            clientBuilder.region(Region.of((String)region));
            if (isOverrideEndpoint && ObjectHelper.isNotEmpty((String)uriEndpointOverride)) {
                clientBuilder.endpointOverride(URI.create(uriEndpointOverride));
            }
            this.client = (SecretsManagerClient)clientBuilder.build();
        } else {
            throw new RuntimeCamelException("Using the AWS Secrets Manager Properties Function requires setting AWS credentials as application properties or environment variables");
        }
    }

    protected void doStop() throws Exception {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.client = null;
        }
        this.secrets.clear();
        super.doStop();
    }

    public String getName() {
        return "aws";
    }

    public String apply(String remainder) {
        String key = remainder;
        String subkey = null;
        String returnValue = null;
        String defaultValue = null;
        String version = null;
        if (remainder.contains("#")) {
            key = StringHelper.before((String)remainder, (String)"#");
            subkey = StringHelper.after((String)remainder, (String)"#");
            defaultValue = StringHelper.after((String)subkey, (String)":");
            if (ObjectHelper.isNotEmpty((String)defaultValue) && defaultValue.contains("@")) {
                version = StringHelper.after((String)defaultValue, (String)"@");
                defaultValue = StringHelper.before((String)defaultValue, (String)"@");
            }
            if (subkey.contains(":")) {
                subkey = StringHelper.before((String)subkey, (String)":");
            }
            if (subkey.contains("@")) {
                version = StringHelper.after((String)subkey, (String)"@");
                subkey = StringHelper.before((String)subkey, (String)"@");
            }
        } else if (remainder.contains(":")) {
            key = StringHelper.before((String)remainder, (String)":");
            defaultValue = StringHelper.after((String)remainder, (String)":");
            if (remainder.contains("@")) {
                version = StringHelper.after((String)remainder, (String)"@");
                defaultValue = StringHelper.before((String)defaultValue, (String)"@");
            }
        } else if (remainder.contains("@")) {
            key = StringHelper.before((String)remainder, (String)"@");
            version = StringHelper.after((String)remainder, (String)"@");
        }
        if (key != null) {
            try {
                returnValue = this.getSecretFromSource(key, subkey, defaultValue, version);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeCamelException("Something went wrong while recovering " + key + " from vault");
            }
        }
        return returnValue;
    }

    private String getSecretFromSource(String key, String subkey, String defaultValue, String version) throws JsonProcessingException {
        String returnValue;
        this.secrets.add(key);
        GetSecretValueRequest.Builder builder = GetSecretValueRequest.builder();
        builder.secretId(key);
        if (ObjectHelper.isNotEmpty((String)version)) {
            builder.versionId(version);
        }
        GetSecretValueRequest request = (GetSecretValueRequest)builder.build();
        try {
            GetSecretValueResponse secret = this.client.getSecretValue(request);
            returnValue = ObjectHelper.isNotEmpty((String)secret.secretString()) ? secret.secretString() : new String(Base64.getDecoder().decode(secret.secretBinary().asByteBuffer()).array());
            if (ObjectHelper.isNotEmpty((String)subkey)) {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode actualObj = mapper.readTree(returnValue);
                JsonNode field = actualObj.get(subkey);
                returnValue = ObjectHelper.isNotEmpty((Object)field) ? field.textValue() : null;
            }
            if (ObjectHelper.isEmpty((String)returnValue)) {
                returnValue = defaultValue;
            }
        }
        catch (SecretsManagerException ex) {
            if (ObjectHelper.isNotEmpty((String)defaultValue)) {
                returnValue = defaultValue;
            }
            throw ex;
        }
        return returnValue;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public Set<String> getSecrets() {
        return this.secrets;
    }

    public String getRegion() {
        return this.region;
    }

    public boolean isDefaultCredentialsProvider() {
        return this.defaultCredentialsProvider;
    }

    public boolean isProfleCredentialsProvider() {
        return this.profleCredentialsProvider;
    }

    public String getProfileName() {
        return this.profileName;
    }
}

