/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.config.client.impl;

import java.net.URI;
import org.apache.camel.component.aws.config.AWSConfigConfiguration;
import org.apache.camel.component.aws.config.client.AWSConfigInternalClient;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.ConfigClientBuilder;
import software.amazon.awssdk.utils.AttributeMap;

public class AWSConfigClientSessionTokenImpl
implements AWSConfigInternalClient {
    private static final Logger LOG = LoggerFactory.getLogger(AWSConfigClientSessionTokenImpl.class);
    private AWSConfigConfiguration configuration;

    public AWSConfigClientSessionTokenImpl(AWSConfigConfiguration configuration) {
        LOG.trace("Creating an AWS Config manager using static credentials.");
        this.configuration = configuration;
    }

    @Override
    public ConfigClient getConfigClient() {
        ConfigClient client = null;
        ConfigClientBuilder clientBuilder = ConfigClient.builder();
        ProxyConfiguration.Builder proxyConfig = null;
        ApacheHttpClient.Builder httpClientBuilder = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((String)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            proxyConfig = ProxyConfiguration.builder();
            URI proxyEndpoint = URI.create(this.configuration.getProxyProtocol() + "://" + this.configuration.getProxyHost() + ":" + this.configuration.getProxyPort());
            proxyConfig.endpoint(proxyEndpoint);
            httpClientBuilder = ApacheHttpClient.builder().proxyConfiguration((ProxyConfiguration)proxyConfig.build());
            isClientConfigFound = true;
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null && this.configuration.getSessionToken() != null) {
            AwsSessionCredentials cred = AwsSessionCredentials.create((String)this.configuration.getAccessKey(), (String)this.configuration.getSecretKey(), (String)this.configuration.getSessionToken());
            clientBuilder = isClientConfigFound ? (ConfigClientBuilder)((ConfigClientBuilder)clientBuilder.httpClientBuilder((SdkHttpClient.Builder)httpClientBuilder)).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred)) : (ConfigClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred));
        } else if (!isClientConfigFound) {
            clientBuilder = (ConfigClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder);
        }
        if (ObjectHelper.isNotEmpty((String)this.configuration.getRegion())) {
            clientBuilder = (ConfigClientBuilder)clientBuilder.region(Region.of((String)this.configuration.getRegion()));
        }
        if (this.configuration.isOverrideEndpoint()) {
            clientBuilder.endpointOverride(URI.create(this.configuration.getUriEndpointOverride()));
        }
        if (this.configuration.isTrustAllCertificates()) {
            if (httpClientBuilder == null) {
                httpClientBuilder = ApacheHttpClient.builder();
            }
            SdkHttpClient ahc = httpClientBuilder.buildWithDefaults(AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES, (Object)Boolean.TRUE).build());
            clientBuilder.httpClient(ahc);
            clientBuilder.httpClientBuilder(null);
        }
        client = (ConfigClient)clientBuilder.build();
        return client;
    }
}

