/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.config;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.config.AWSConfigConfiguration;
import org.apache.camel.component.aws.config.AWSConfigEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.HealthCheckComponent;

@org.apache.camel.spi.annotations.Component(value="aws-config")
public class AWSConfigComponent
extends HealthCheckComponent {
    @Metadata
    private AWSConfigConfiguration configuration = new AWSConfigConfiguration();

    public AWSConfigComponent() {
        this(null);
    }

    public AWSConfigComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        AWSConfigConfiguration configuration = this.configuration != null ? this.configuration.copy() : new AWSConfigConfiguration();
        AWSConfigEndpoint endpoint = new AWSConfigEndpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (Boolean.FALSE.equals(configuration.isUseDefaultCredentialsProvider()) && Boolean.FALSE.equals(configuration.isUseProfileCredentialsProvider()) && Boolean.FALSE.equals(configuration.isUseSessionCredentials()) && configuration.getConfigClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("useDefaultCredentialsProvider is set to false, useProfileCredentialsProvider is set to false, useSessionCredentials is set to false, Amazon config client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public AWSConfigConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(AWSConfigConfiguration configuration) {
        this.configuration = configuration;
    }
}

