/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.config.client;

import org.apache.camel.component.aws.config.AWSConfigConfiguration;
import org.apache.camel.component.aws.config.client.AWSConfigInternalClient;
import org.apache.camel.component.aws.config.client.impl.AWSConfigClientIAMOptimizedImpl;
import org.apache.camel.component.aws.config.client.impl.AWSConfigClientIAMProfileOptimizedImpl;
import org.apache.camel.component.aws.config.client.impl.AWSConfigClientSessionTokenImpl;
import org.apache.camel.component.aws.config.client.impl.AWSConfigClientStandardImpl;

public final class AWSConfigClientFactory {
    private AWSConfigClientFactory() {
    }

    public static AWSConfigInternalClient getConfigClient(AWSConfigConfiguration configuration) {
        if (Boolean.TRUE.equals(configuration.isUseDefaultCredentialsProvider())) {
            return new AWSConfigClientIAMOptimizedImpl(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseProfileCredentialsProvider())) {
            return new AWSConfigClientIAMProfileOptimizedImpl(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseSessionCredentials())) {
            return new AWSConfigClientSessionTokenImpl(configuration);
        }
        return new AWSConfigClientStandardImpl(configuration);
    }
}

