/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.cloudtrail.client.impl;

import java.net.URI;
import org.apache.camel.component.aws.cloudtrail.CloudtrailConfiguration;
import org.apache.camel.component.aws.cloudtrail.client.CloudtrailInternalClient;
import org.apache.camel.component.aws.cloudtrail.client.impl.CloudtrailClientStandardImpl;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudtrail.CloudTrailClient;
import software.amazon.awssdk.services.cloudtrail.CloudTrailClientBuilder;
import software.amazon.awssdk.utils.AttributeMap;

public class CloudtrailClientSessionTokenImpl
implements CloudtrailInternalClient {
    private static final Logger LOG = LoggerFactory.getLogger(CloudtrailClientStandardImpl.class);
    private CloudtrailConfiguration configuration;

    public CloudtrailClientSessionTokenImpl(CloudtrailConfiguration configuration) {
        LOG.trace("Creating an AWS Cloudtrail manager using static credentials.");
        this.configuration = configuration;
    }

    @Override
    public CloudTrailClient getCloudtrailClient() {
        CloudTrailClient client = null;
        CloudTrailClientBuilder clientBuilder = CloudTrailClient.builder();
        ProxyConfiguration.Builder proxyConfig = null;
        ApacheHttpClient.Builder httpClientBuilder = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((String)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            proxyConfig = ProxyConfiguration.builder();
            URI proxyEndpoint = URI.create(this.configuration.getProxyProtocol() + "://" + this.configuration.getProxyHost() + ":" + this.configuration.getProxyPort());
            proxyConfig.endpoint(proxyEndpoint);
            httpClientBuilder = ApacheHttpClient.builder().proxyConfiguration((ProxyConfiguration)proxyConfig.build());
            isClientConfigFound = true;
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null) {
            AwsSessionCredentials cred = AwsSessionCredentials.create((String)this.configuration.getAccessKey(), (String)this.configuration.getSecretKey(), (String)this.configuration.getSessionToken());
            clientBuilder = isClientConfigFound ? (CloudTrailClientBuilder)((CloudTrailClientBuilder)clientBuilder.httpClientBuilder((SdkHttpClient.Builder)httpClientBuilder)).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred)) : (CloudTrailClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred));
        } else if (!isClientConfigFound) {
            clientBuilder = (CloudTrailClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder);
        }
        if (ObjectHelper.isNotEmpty((String)this.configuration.getRegion())) {
            clientBuilder = (CloudTrailClientBuilder)clientBuilder.region(Region.of((String)this.configuration.getRegion()));
        }
        if (this.configuration.isOverrideEndpoint()) {
            clientBuilder.endpointOverride(URI.create(this.configuration.getUriEndpointOverride()));
        }
        if (this.configuration.isTrustAllCertificates()) {
            if (httpClientBuilder == null) {
                httpClientBuilder = ApacheHttpClient.builder();
            }
            SdkHttpClient ahc = httpClientBuilder.buildWithDefaults(AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES, (Object)Boolean.TRUE).build());
            clientBuilder.httpClient(ahc);
            clientBuilder.httpClientBuilder(null);
        }
        client = (CloudTrailClient)clientBuilder.build();
        return client;
    }
}

