/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.cloudtrail;

import org.apache.camel.CamelContext;
import org.apache.camel.component.aws.cloudtrail.CloudtrailComponent;
import org.apache.camel.component.aws.cloudtrail.CloudtrailConfiguration;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.cloudtrail.CloudTrailClient;

public class CloudtrailComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private CloudtrailConfiguration getOrCreateConfiguration(CloudtrailComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new CloudtrailConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        CloudtrailComponent target = (CloudtrailComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                this.getOrCreateConfiguration(target).setAccessKey((String)CloudtrailComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled((Boolean)CloudtrailComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)CloudtrailComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "cloudtrailclient": 
            case "cloudTrailClient": {
                this.getOrCreateConfiguration(target).setCloudTrailClient((CloudTrailClient)CloudtrailComponentConfigurer.property((CamelContext)camelContext, CloudTrailClient.class, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((CloudtrailConfiguration)CloudtrailComponentConfigurer.property((CamelContext)camelContext, CloudtrailConfiguration.class, (Object)value));
                return true;
            }
            case "eventsource": 
            case "eventSource": {
                this.getOrCreateConfiguration(target).setEventSource((String)CloudtrailComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "healthcheckconsumerenabled": 
            case "healthCheckConsumerEnabled": {
                target.setHealthCheckConsumerEnabled((Boolean)CloudtrailComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "healthcheckproducerenabled": 
            case "healthCheckProducerEnabled": {
                target.setHealthCheckProducerEnabled((Boolean)CloudtrailComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "maxresults": 
            case "maxResults": {
                this.getOrCreateConfiguration(target).setMaxResults((Integer)CloudtrailComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "overrideendpoint": 
            case "overrideEndpoint": {
                this.getOrCreateConfiguration(target).setOverrideEndpoint((Boolean)CloudtrailComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "profilecredentialsname": 
            case "profileCredentialsName": {
                this.getOrCreateConfiguration(target).setProfileCredentialsName((String)CloudtrailComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyhost": 
            case "proxyHost": {
                this.getOrCreateConfiguration(target).setProxyHost((String)CloudtrailComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": 
            case "proxyPort": {
                this.getOrCreateConfiguration(target).setProxyPort((Integer)CloudtrailComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                this.getOrCreateConfiguration(target).setProxyProtocol((Protocol)CloudtrailComponentConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "region": {
                this.getOrCreateConfiguration(target).setRegion((String)CloudtrailComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": 
            case "secretKey": {
                this.getOrCreateConfiguration(target).setSecretKey((String)CloudtrailComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "trustallcertificates": 
            case "trustAllCertificates": {
                this.getOrCreateConfiguration(target).setTrustAllCertificates((Boolean)CloudtrailComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "uriendpointoverride": 
            case "uriEndpointOverride": {
                this.getOrCreateConfiguration(target).setUriEndpointOverride((String)CloudtrailComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "usedefaultcredentialsprovider": 
            case "useDefaultCredentialsProvider": {
                this.getOrCreateConfiguration(target).setUseDefaultCredentialsProvider((Boolean)CloudtrailComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "useprofilecredentialsprovider": 
            case "useProfileCredentialsProvider": {
                this.getOrCreateConfiguration(target).setUseProfileCredentialsProvider((Boolean)CloudtrailComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    public String[] getAutowiredNames() {
        return new String[]{"cloudTrailClient"};
    }

    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return String.class;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "cloudtrailclient": 
            case "cloudTrailClient": {
                return CloudTrailClient.class;
            }
            case "configuration": {
                return CloudtrailConfiguration.class;
            }
            case "eventsource": 
            case "eventSource": {
                return String.class;
            }
            case "healthcheckconsumerenabled": 
            case "healthCheckConsumerEnabled": {
                return Boolean.TYPE;
            }
            case "healthcheckproducerenabled": 
            case "healthCheckProducerEnabled": {
                return Boolean.TYPE;
            }
            case "maxresults": 
            case "maxResults": {
                return Integer.TYPE;
            }
            case "overrideendpoint": 
            case "overrideEndpoint": {
                return Boolean.TYPE;
            }
            case "profilecredentialsname": 
            case "profileCredentialsName": {
                return String.class;
            }
            case "proxyhost": 
            case "proxyHost": {
                return String.class;
            }
            case "proxyport": 
            case "proxyPort": {
                return Integer.class;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return Protocol.class;
            }
            case "region": {
                return String.class;
            }
            case "secretkey": 
            case "secretKey": {
                return String.class;
            }
            case "trustallcertificates": 
            case "trustAllCertificates": {
                return Boolean.TYPE;
            }
            case "uriendpointoverride": 
            case "uriEndpointOverride": {
                return String.class;
            }
            case "usedefaultcredentialsprovider": 
            case "useDefaultCredentialsProvider": {
                return Boolean.TYPE;
            }
            case "useprofilecredentialsprovider": 
            case "useProfileCredentialsProvider": {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        CloudtrailComponent target = (CloudtrailComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return this.getOrCreateConfiguration(target).getAccessKey();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "cloudtrailclient": 
            case "cloudTrailClient": {
                return this.getOrCreateConfiguration(target).getCloudTrailClient();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "eventsource": 
            case "eventSource": {
                return this.getOrCreateConfiguration(target).getEventSource();
            }
            case "healthcheckconsumerenabled": 
            case "healthCheckConsumerEnabled": {
                return target.isHealthCheckConsumerEnabled();
            }
            case "healthcheckproducerenabled": 
            case "healthCheckProducerEnabled": {
                return target.isHealthCheckProducerEnabled();
            }
            case "maxresults": 
            case "maxResults": {
                return this.getOrCreateConfiguration(target).getMaxResults();
            }
            case "overrideendpoint": 
            case "overrideEndpoint": {
                return this.getOrCreateConfiguration(target).isOverrideEndpoint();
            }
            case "profilecredentialsname": 
            case "profileCredentialsName": {
                return this.getOrCreateConfiguration(target).getProfileCredentialsName();
            }
            case "proxyhost": 
            case "proxyHost": {
                return this.getOrCreateConfiguration(target).getProxyHost();
            }
            case "proxyport": 
            case "proxyPort": {
                return this.getOrCreateConfiguration(target).getProxyPort();
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return this.getOrCreateConfiguration(target).getProxyProtocol();
            }
            case "region": {
                return this.getOrCreateConfiguration(target).getRegion();
            }
            case "secretkey": 
            case "secretKey": {
                return this.getOrCreateConfiguration(target).getSecretKey();
            }
            case "trustallcertificates": 
            case "trustAllCertificates": {
                return this.getOrCreateConfiguration(target).isTrustAllCertificates();
            }
            case "uriendpointoverride": 
            case "uriEndpointOverride": {
                return this.getOrCreateConfiguration(target).getUriEndpointOverride();
            }
            case "usedefaultcredentialsprovider": 
            case "useDefaultCredentialsProvider": {
                return this.getOrCreateConfiguration(target).isUseDefaultCredentialsProvider();
            }
            case "useprofilecredentialsprovider": 
            case "useProfileCredentialsProvider": {
                return this.getOrCreateConfiguration(target).isUseProfileCredentialsProvider();
            }
        }
        return null;
    }
}

