/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.bedrock.runtime;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.bedrock.runtime.BedrockConfiguration;
import org.apache.camel.component.aws2.bedrock.runtime.BedrockEndpoint;
import org.apache.camel.component.aws2.bedrock.runtime.BedrockOperations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClient;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelRequest;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelResponse;

public class BedrockProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(BedrockProducer.class);
    private transient String bedrockProducerToString;

    public BedrockProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case invokeTextModel: {
                this.invokeTextModel(this.getEndpoint().getBedrockRuntimeClient(), exchange);
                break;
            }
            case invokeImageModel: {
                this.invokeImageModel(this.getEndpoint().getBedrockRuntimeClient(), exchange);
                break;
            }
            case invokeEmbeddingsModel: {
                this.invokeEmbeddingsModel(this.getEndpoint().getBedrockRuntimeClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private BedrockOperations determineOperation(Exchange exchange) {
        BedrockOperations operation = (BedrockOperations)((Object)exchange.getIn().getHeader("CamelAwsBedrockOperation", BedrockOperations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected BedrockConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.bedrockProducerToString == null) {
            this.bedrockProducerToString = "BedrockProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.bedrockProducerToString;
    }

    public BedrockEndpoint getEndpoint() {
        return (BedrockEndpoint)super.getEndpoint();
    }

    private void invokeTextModel(BedrockRuntimeClient bedrockRuntimeClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getMessage().getMandatoryBody();
            if (payload instanceof InvokeModelRequest) {
                InvokeModelResponse result;
                try {
                    result = bedrockRuntimeClient.invokeModel((InvokeModelRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Invoke Model command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = BedrockProducer.getMessageForResponse(exchange);
                this.setResponseText(result, message);
            }
        } else {
            InvokeModelResponse result;
            InvokeModelRequest.Builder builder = InvokeModelRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getMessage().getHeader("CamelAwsBedrockContentType"))) {
                throw new IllegalArgumentException("Model Content Type must be specified");
            }
            String contentType = (String)exchange.getIn().getHeader("CamelAwsBedrockContentType", String.class);
            builder.contentType(contentType);
            if (!ObjectHelper.isNotEmpty((Object)exchange.getMessage().getHeader("CamelAwsBedrockAcceptContentType"))) {
                throw new IllegalArgumentException("Model Accept Content Type must be specified");
            }
            String acceptContentType = (String)exchange.getIn().getHeader("CamelAwsBedrockAcceptContentType", String.class);
            builder.accept(acceptContentType);
            InvokeModelRequest request = (InvokeModelRequest)builder.body(SdkBytes.fromUtf8String((String)String.valueOf(exchange.getMessage().getBody()))).modelId(this.getConfiguration().getModelId()).build();
            try {
                result = bedrockRuntimeClient.invokeModel(request);
            }
            catch (AwsServiceException ase) {
                LOG.trace("Invoke Model command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = BedrockProducer.getMessageForResponse(exchange);
            this.setResponseText(result, message);
        }
    }

    private void invokeImageModel(BedrockRuntimeClient bedrockRuntimeClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getMessage().getMandatoryBody();
            if (payload instanceof InvokeModelRequest) {
                InvokeModelResponse result;
                try {
                    result = bedrockRuntimeClient.invokeModel((InvokeModelRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Invoke Image Model command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = BedrockProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            InvokeModelResponse result;
            InvokeModelRequest.Builder builder = InvokeModelRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getMessage().getHeader("CamelAwsBedrockContentType"))) {
                throw new IllegalArgumentException("Model Content Type must be specified");
            }
            String contentType = (String)exchange.getIn().getHeader("CamelAwsBedrockContentType", String.class);
            builder.contentType(contentType);
            if (!ObjectHelper.isNotEmpty((Object)exchange.getMessage().getHeader("CamelAwsBedrockAcceptContentType"))) {
                throw new IllegalArgumentException("Model Accept Content Type must be specified");
            }
            String acceptContentType = (String)exchange.getIn().getHeader("CamelAwsBedrockAcceptContentType", String.class);
            builder.accept(acceptContentType);
            InvokeModelRequest request = (InvokeModelRequest)builder.body(SdkBytes.fromUtf8String((String)String.valueOf(exchange.getMessage().getBody()))).modelId(this.getConfiguration().getModelId()).build();
            try {
                result = bedrockRuntimeClient.invokeModel(request);
            }
            catch (AwsServiceException ase) {
                LOG.trace("Invoke Model command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = BedrockProducer.getMessageForResponse(exchange);
            try {
                BedrockProducer.setBase64Image(result, message);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void invokeEmbeddingsModel(BedrockRuntimeClient bedrockRuntimeClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getMessage().getMandatoryBody();
            if (payload instanceof InvokeModelRequest) {
                InvokeModelResponse result;
                try {
                    result = bedrockRuntimeClient.invokeModel((InvokeModelRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Invoke Image Model command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = BedrockProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            InvokeModelResponse result;
            InvokeModelRequest.Builder builder = InvokeModelRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getMessage().getHeader("CamelAwsBedrockContentType"))) {
                throw new IllegalArgumentException("Model Content Type must be specified");
            }
            String contentType = (String)exchange.getIn().getHeader("CamelAwsBedrockContentType", String.class);
            builder.contentType(contentType);
            if (!ObjectHelper.isNotEmpty((Object)exchange.getMessage().getHeader("CamelAwsBedrockAcceptContentType"))) {
                throw new IllegalArgumentException("Model Accept Content Type must be specified");
            }
            String acceptContentType = (String)exchange.getIn().getHeader("CamelAwsBedrockAcceptContentType", String.class);
            builder.accept(acceptContentType);
            InvokeModelRequest request = (InvokeModelRequest)builder.body(SdkBytes.fromUtf8String((String)String.valueOf(exchange.getMessage().getBody()))).modelId(this.getConfiguration().getModelId()).build();
            try {
                result = bedrockRuntimeClient.invokeModel(request);
            }
            catch (AwsServiceException ase) {
                LOG.trace("Invoke Model command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = BedrockProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private static void setBase64Image(InvokeModelResponse result, Message message) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonString = mapper.readTree(result.body().asUtf8String());
        message.setBody((Object)jsonString.get("images"));
    }

    protected void setResponseText(InvokeModelResponse result, Message message) {
        switch (this.getConfiguration().getModelId()) {
            case "amazon.titan-text-express-v1": 
            case "amazon.titan-text-lite-v1": {
                this.setTitanText(result, message);
                break;
            }
            case "ai21.j2-ultra-v1": 
            case "ai21.j2-mid-v1": {
                try {
                    this.setAi21Text(result, message);
                    break;
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
            case "anthropic.claude-instant-v1": 
            case "anthropic.claude-v2": 
            case "anthropic.claude-v2:1": {
                try {
                    this.setAnthropicText(result, message);
                    break;
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
            case "anthropic.claude-3-sonnet-20240229-v1:0": {
                try {
                    this.setAnthropicV3Text(result, message);
                    break;
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + this.getConfiguration().getModelId());
            }
        }
    }

    private void setTitanText(InvokeModelResponse result, Message message) {
        message.setBody((Object)result.body().asUtf8String());
    }

    private void setAi21Text(InvokeModelResponse result, Message message) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonString = mapper.readTree(result.body().asUtf8String());
        message.setBody((Object)jsonString.get("completions"));
    }

    private void setAnthropicText(InvokeModelResponse result, Message message) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonString = mapper.readTree(result.body().asUtf8String());
        message.setBody((Object)jsonString.get("completion"));
    }

    private void setAnthropicV3Text(InvokeModelResponse result, Message message) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonString = mapper.readTree(result.body().asUtf8String());
        message.setBody((Object)jsonString);
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }
}

