/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.bedrock.agentruntime;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.bedrock.agentruntime.BedrockAgentRuntimeConfiguration;
import org.apache.camel.component.aws2.bedrock.agentruntime.BedrockAgentRuntimeEndpoint;
import org.apache.camel.component.aws2.bedrock.agentruntime.BedrockAgentRuntimeOperations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.bedrockagentruntime.BedrockAgentRuntimeClient;
import software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBaseRetrievalConfiguration;
import software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBaseRetrieveAndGenerateConfiguration;
import software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBaseVectorSearchConfiguration;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateConfiguration;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateInput;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateType;

public class BedrockAgentRuntimeProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(BedrockAgentRuntimeProducer.class);
    private transient String bedrockAgentRuntimeProducerToString;

    public BedrockAgentRuntimeProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case retrieveAndGenerate: {
                this.retrieveAndGenerate(this.getEndpoint().getBedrockAgentRuntimeClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private BedrockAgentRuntimeOperations determineOperation(Exchange exchange) {
        BedrockAgentRuntimeOperations operation = (BedrockAgentRuntimeOperations)((Object)exchange.getIn().getHeader("CamelAwsBedrockAgentRuntimeOperation", BedrockAgentRuntimeOperations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected BedrockAgentRuntimeConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.bedrockAgentRuntimeProducerToString == null) {
            this.bedrockAgentRuntimeProducerToString = "BedrockAgentRuntimeProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.bedrockAgentRuntimeProducerToString;
    }

    public BedrockAgentRuntimeEndpoint getEndpoint() {
        return (BedrockAgentRuntimeEndpoint)super.getEndpoint();
    }

    private void retrieveAndGenerate(BedrockAgentRuntimeClient bedrockAgentRuntimeClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getMessage().getMandatoryBody();
            if (payload instanceof RetrieveAndGenerateRequest) {
                RetrieveAndGenerateResponse result;
                try {
                    result = bedrockAgentRuntimeClient.retrieveAndGenerate((RetrieveAndGenerateRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Retrieve and Generate command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = BedrockAgentRuntimeProducer.getMessageForResponse(exchange);
                this.prepareResponse(result, message);
            }
        } else {
            String inputText = (String)exchange.getMessage().getMandatoryBody(String.class);
            KnowledgeBaseVectorSearchConfiguration knowledgeBaseVectorSearchConfiguration = (KnowledgeBaseVectorSearchConfiguration)KnowledgeBaseVectorSearchConfiguration.builder().build();
            KnowledgeBaseRetrievalConfiguration knowledgeBaseRetrievalConfiguration = (KnowledgeBaseRetrievalConfiguration)KnowledgeBaseRetrievalConfiguration.builder().vectorSearchConfiguration(knowledgeBaseVectorSearchConfiguration).build();
            KnowledgeBaseRetrieveAndGenerateConfiguration configuration = (KnowledgeBaseRetrieveAndGenerateConfiguration)KnowledgeBaseRetrieveAndGenerateConfiguration.builder().knowledgeBaseId(this.getConfiguration().getKnowledgeBaseId()).modelArn(this.getConfiguration().getModelId()).retrievalConfiguration(knowledgeBaseRetrievalConfiguration).build();
            RetrieveAndGenerateType type = RetrieveAndGenerateType.KNOWLEDGE_BASE;
            RetrieveAndGenerateConfiguration build = (RetrieveAndGenerateConfiguration)RetrieveAndGenerateConfiguration.builder().knowledgeBaseConfiguration(configuration).type(type).build();
            RetrieveAndGenerateInput input = (RetrieveAndGenerateInput)RetrieveAndGenerateInput.builder().text(inputText).build();
            RetrieveAndGenerateResponse retrieveAndGenerateResponse = bedrockAgentRuntimeClient.retrieveAndGenerate((RetrieveAndGenerateRequest)RetrieveAndGenerateRequest.builder().retrieveAndGenerateConfiguration(build).input(input).build());
            Message message = BedrockAgentRuntimeProducer.getMessageForResponse(exchange);
            this.prepareResponse(retrieveAndGenerateResponse, message);
        }
    }

    private void prepareResponse(RetrieveAndGenerateResponse result, Message message) {
        if (result.hasCitations()) {
            message.setHeader("CamelAwsBedrockAgentRuntimeCitations", (Object)result.citations());
        }
        if (ObjectHelper.isNotEmpty((String)result.sessionId())) {
            message.setHeader("CamelAwsBedrockAgentRuntimeSessionId", (Object)result.sessionId());
        }
        message.setBody((Object)result.output().text());
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }
}

