/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.bedrock.agent;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.bedrock.agent.BedrockAgentConfiguration;
import org.apache.camel.component.aws2.bedrock.agent.BedrockAgentEndpoint;
import org.apache.camel.component.aws2.bedrock.agent.BedrockAgentOperations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.bedrockagent.BedrockAgentClient;
import software.amazon.awssdk.services.bedrockagent.model.GetIngestionJobRequest;
import software.amazon.awssdk.services.bedrockagent.model.GetIngestionJobResponse;
import software.amazon.awssdk.services.bedrockagent.model.ListIngestionJobsRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListIngestionJobsResponse;
import software.amazon.awssdk.services.bedrockagent.model.StartIngestionJobRequest;
import software.amazon.awssdk.services.bedrockagent.model.StartIngestionJobResponse;

public class BedrockAgentProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(BedrockAgentProducer.class);
    private transient String bedrockAgentProducerToString;

    public BedrockAgentProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case startIngestionJob: {
                this.startIngestionJob(this.getEndpoint().getBedrockAgentClient(), exchange);
                break;
            }
            case listIngestionJobs: {
                this.listIngestionJobs(this.getEndpoint().getBedrockAgentClient(), exchange);
                break;
            }
            case getIngestionJob: {
                this.getIngestionJob(this.getEndpoint().getBedrockAgentClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private BedrockAgentOperations determineOperation(Exchange exchange) {
        BedrockAgentOperations operation = (BedrockAgentOperations)((Object)exchange.getIn().getHeader("CamelAwsBedrockAgentOperation", BedrockAgentOperations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected BedrockAgentConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.bedrockAgentProducerToString == null) {
            this.bedrockAgentProducerToString = "BedrockAgentProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.bedrockAgentProducerToString;
    }

    public BedrockAgentEndpoint getEndpoint() {
        return (BedrockAgentEndpoint)super.getEndpoint();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void startIngestionJob(BedrockAgentClient bedrockAgentClient, Exchange exchange) throws InvalidPayloadException {
        String dataSourceId;
        String knowledgeBaseId;
        if (this.getConfiguration().isPojoRequest()) {
            StartIngestionJobResponse result;
            Object payload = exchange.getMessage().getMandatoryBody();
            if (!(payload instanceof StartIngestionJobRequest)) return;
            try {
                result = bedrockAgentClient.startIngestionJob((StartIngestionJobRequest)payload);
            }
            catch (AwsServiceException ase) {
                LOG.trace("Start Ingestion Job command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = BedrockAgentProducer.getMessageForResponse(exchange);
            this.prepareIngestionJobResponse(result, message);
            return;
        }
        StartIngestionJobRequest.Builder builder = StartIngestionJobRequest.builder();
        if (ObjectHelper.isEmpty((String)this.getConfiguration().getKnowledgeBaseId())) {
            if (!ObjectHelper.isNotEmpty((Object)exchange.getMessage().getHeader("CamelAwsBedrockAgentKnowledgeBaseId"))) throw new IllegalArgumentException("KnowledgeBaseId must be specified");
            knowledgeBaseId = (String)exchange.getIn().getHeader("CamelAwsBedrockAgentKnowledgeBaseId", String.class);
        } else {
            knowledgeBaseId = this.getConfiguration().getKnowledgeBaseId();
        }
        if (ObjectHelper.isEmpty((String)this.getConfiguration().getDataSourceId())) {
            if (!ObjectHelper.isNotEmpty((Object)exchange.getMessage().getHeader("CamelAwsBedrockAgentDataSourceId"))) throw new IllegalArgumentException("DataSourceId must be specified");
            dataSourceId = (String)exchange.getIn().getHeader("CamelAwsBedrockAgentDataSourceId", String.class);
        } else {
            dataSourceId = this.getConfiguration().getDataSourceId();
        }
        builder.knowledgeBaseId(knowledgeBaseId);
        builder.dataSourceId(dataSourceId);
        StartIngestionJobResponse output = bedrockAgentClient.startIngestionJob((StartIngestionJobRequest)builder.build());
        Message message = BedrockAgentProducer.getMessageForResponse(exchange);
        this.prepareIngestionJobResponse(output, message);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void listIngestionJobs(BedrockAgentClient bedrockAgentClient, Exchange exchange) throws InvalidPayloadException {
        String dataSourceId;
        String knowledgeBaseId;
        if (this.getConfiguration().isPojoRequest()) {
            ListIngestionJobsResponse result;
            Object payload = exchange.getMessage().getMandatoryBody();
            if (!(payload instanceof ListIngestionJobsRequest)) return;
            try {
                result = bedrockAgentClient.listIngestionJobs((ListIngestionJobsRequest)payload);
            }
            catch (AwsServiceException ase) {
                LOG.trace("Start Ingestion Job command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = BedrockAgentProducer.getMessageForResponse(exchange);
            this.prepareListIngestionJobsResponse(result, message);
            return;
        }
        ListIngestionJobsRequest.Builder builder = ListIngestionJobsRequest.builder();
        if (ObjectHelper.isEmpty((String)this.getConfiguration().getKnowledgeBaseId())) {
            if (!ObjectHelper.isNotEmpty((Object)exchange.getMessage().getHeader("CamelAwsBedrockAgentKnowledgeBaseId"))) throw new IllegalArgumentException("KnowledgeBaseId must be specified");
            knowledgeBaseId = (String)exchange.getIn().getHeader("CamelAwsBedrockAgentKnowledgeBaseId", String.class);
        } else {
            knowledgeBaseId = this.getConfiguration().getKnowledgeBaseId();
        }
        if (ObjectHelper.isEmpty((String)this.getConfiguration().getDataSourceId())) {
            if (!ObjectHelper.isNotEmpty((Object)exchange.getMessage().getHeader("CamelAwsBedrockAgentDataSourceId"))) throw new IllegalArgumentException("DataSourceId must be specified");
            dataSourceId = (String)exchange.getIn().getHeader("CamelAwsBedrockAgentDataSourceId", String.class);
        } else {
            dataSourceId = this.getConfiguration().getDataSourceId();
        }
        builder.knowledgeBaseId(knowledgeBaseId);
        builder.dataSourceId(dataSourceId);
        ListIngestionJobsResponse output = bedrockAgentClient.listIngestionJobs((ListIngestionJobsRequest)builder.build());
        Message message = BedrockAgentProducer.getMessageForResponse(exchange);
        this.prepareListIngestionJobsResponse(output, message);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getIngestionJob(BedrockAgentClient bedrockAgentClient, Exchange exchange) throws InvalidPayloadException {
        String ingestionJobId;
        String dataSourceId;
        String knowledgeBaseId;
        if (this.getConfiguration().isPojoRequest()) {
            GetIngestionJobResponse result;
            Object payload = exchange.getMessage().getMandatoryBody();
            if (!(payload instanceof GetIngestionJobRequest)) return;
            try {
                result = bedrockAgentClient.getIngestionJob((GetIngestionJobRequest)payload);
            }
            catch (AwsServiceException ase) {
                LOG.trace("Get Ingestion Job command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = BedrockAgentProducer.getMessageForResponse(exchange);
            this.prepareGetIngestionJobResponse(result, message);
            return;
        }
        GetIngestionJobRequest.Builder builder = GetIngestionJobRequest.builder();
        if (ObjectHelper.isEmpty((String)this.getConfiguration().getKnowledgeBaseId())) {
            if (!ObjectHelper.isNotEmpty((Object)exchange.getMessage().getHeader("CamelAwsBedrockAgentKnowledgeBaseId"))) throw new IllegalArgumentException("KnowledgeBaseId must be specified");
            knowledgeBaseId = (String)exchange.getMessage().getHeader("CamelAwsBedrockAgentKnowledgeBaseId", String.class);
        } else {
            knowledgeBaseId = this.getConfiguration().getKnowledgeBaseId();
        }
        if (ObjectHelper.isEmpty((String)this.getConfiguration().getDataSourceId())) {
            if (!ObjectHelper.isNotEmpty((Object)exchange.getMessage().getHeader("CamelAwsBedrockAgentDataSourceId"))) throw new IllegalArgumentException("DataSourceId must be specified");
            dataSourceId = (String)exchange.getMessage().getHeader("CamelAwsBedrockAgentDataSourceId", String.class);
        } else {
            dataSourceId = this.getConfiguration().getDataSourceId();
        }
        if (ObjectHelper.isEmpty((String)this.getConfiguration().getIngestionJobId())) {
            if (!ObjectHelper.isNotEmpty((Object)exchange.getMessage().getHeader("CamelAwsBedrockAgentIngestionJobId"))) throw new IllegalArgumentException("IngestionJobId must be specified");
            ingestionJobId = (String)exchange.getMessage().getHeader("CamelAwsBedrockAgentIngestionJobId", String.class);
        } else {
            ingestionJobId = this.getConfiguration().getIngestionJobId();
        }
        builder.knowledgeBaseId(knowledgeBaseId);
        builder.dataSourceId(dataSourceId);
        builder.ingestionJobId(ingestionJobId);
        GetIngestionJobResponse output = bedrockAgentClient.getIngestionJob((GetIngestionJobRequest)builder.build());
        Message message = BedrockAgentProducer.getMessageForResponse(exchange);
        this.prepareGetIngestionJobResponse(output, message);
    }

    private void prepareIngestionJobResponse(StartIngestionJobResponse result, Message message) {
        message.setBody((Object)result.ingestionJob().ingestionJobId());
    }

    private void prepareListIngestionJobsResponse(ListIngestionJobsResponse result, Message message) {
        if (result.hasIngestionJobSummaries()) {
            message.setBody((Object)result.ingestionJobSummaries());
        }
    }

    private void prepareGetIngestionJobResponse(GetIngestionJobResponse result, Message message) {
        message.setBody((Object)result.ingestionJob().ingestionJobId());
        message.setHeader("CamelAwsBedrockAgentIngestionJobStatus", (Object)result.ingestionJob().status());
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }
}

