/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atomix.client.value;

import io.atomix.resource.ReadConsistency;
import io.atomix.resource.Resource;
import io.atomix.variables.DistributedValue;
import java.time.Duration;
import org.apache.camel.AsyncCallback;
import org.apache.camel.InvokeOnHeader;
import org.apache.camel.Message;
import org.apache.camel.component.atomix.client.AbstractAtomixClientProducer;
import org.apache.camel.component.atomix.client.value.AtomixValueConfiguration;
import org.apache.camel.component.atomix.client.value.AtomixValueEndpoint;
import org.apache.camel.util.ObjectHelper;

final class AtomixValueProducer
extends AbstractAtomixClientProducer<AtomixValueEndpoint, DistributedValue> {
    private final AtomixValueConfiguration configuration;

    protected AtomixValueProducer(AtomixValueEndpoint endpoint) {
        super(endpoint);
        this.configuration = endpoint.getConfiguration();
    }

    @InvokeOnHeader(value="SET")
    boolean onSet(Message message, AsyncCallback callback) throws Exception {
        DistributedValue value = (DistributedValue)this.getResource(message);
        long ttl = (Long)message.getHeader("CamelAtomixResourceTTL", this.configuration::getTtl, Long.TYPE);
        Object val = message.getHeader("CamelAtomixResourceValue", () -> ((Message)message).getBody(), Object.class);
        ObjectHelper.notNull((Object)val, (String)"CamelAtomixResourceValue");
        if (ttl > 0L) {
            value.set(val, Duration.ofMillis(ttl)).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            value.set(val).thenAccept(result -> this.processResult(message, callback, result));
        }
        return false;
    }

    @InvokeOnHeader(value="GET")
    boolean onGet(Message message, AsyncCallback callback) throws Exception {
        DistributedValue value = (DistributedValue)this.getResource(message);
        ReadConsistency consistency = (ReadConsistency)message.getHeader("CamelAtomixResourceReadConsistency", this.configuration::getReadConsistency, ReadConsistency.class);
        if (consistency != null) {
            value.get(consistency).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            value.get().thenAccept(result -> this.processResult(message, callback, result));
        }
        return false;
    }

    @InvokeOnHeader(value="GET_AND_SET")
    boolean onGetAndSet(Message message, AsyncCallback callback) throws Exception {
        DistributedValue value = (DistributedValue)this.getResource(message);
        long ttl = (Long)message.getHeader("CamelAtomixResourceTTL", this.configuration::getTtl, Long.TYPE);
        Object val = message.getHeader("CamelAtomixResourceValue", () -> ((Message)message).getBody(), Object.class);
        ObjectHelper.notNull((Object)val, (String)"CamelAtomixResourceValue");
        if (ttl > 0L) {
            value.getAndSet(val, Duration.ofMillis(ttl)).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            value.getAndSet(val).thenAccept(result -> this.processResult(message, callback, result));
        }
        return false;
    }

    @InvokeOnHeader(value="COMPARE_AND_SET")
    boolean onCompareAndSet(Message message, AsyncCallback callback) throws Exception {
        DistributedValue value = (DistributedValue)this.getResource(message);
        long ttl = (Long)message.getHeader("CamelAtomixResourceTTL", this.configuration::getTtl, Long.TYPE);
        Object newVal = message.getHeader("CamelAtomixResourceValue", () -> ((Message)message).getBody(), Object.class);
        Object oldVal = message.getHeader("CamelAtomixResourceOldValue", Object.class);
        ObjectHelper.notNull((Object)newVal, (String)"CamelAtomixResourceValue");
        ObjectHelper.notNull((Object)oldVal, (String)"CamelAtomixResourceOldValue");
        if (ttl > 0L) {
            value.compareAndSet(oldVal, newVal, Duration.ofMillis(ttl)).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            value.compareAndSet(oldVal, newVal).thenAccept(result -> this.processResult(message, callback, result));
        }
        return false;
    }

    @Override
    protected String getProcessorKey(Message message) {
        return (String)message.getHeader("CamelAtomixResourceAction", this.configuration::getDefaultAction, String.class);
    }

    @Override
    protected String getResourceName(Message message) {
        return (String)message.getHeader("CamelAtomixResourceName", ((AtomixValueEndpoint)((Object)this.getAtomixEndpoint()))::getResourceName, String.class);
    }

    @Override
    protected DistributedValue<Object> createResource(String resourceName) {
        return (DistributedValue)((AtomixValueEndpoint)((Object)this.getAtomixEndpoint())).getAtomix().getValue(resourceName, new Resource.Config(((AtomixValueEndpoint)((Object)this.getAtomixEndpoint())).getConfiguration().getResourceOptions(resourceName)), new Resource.Options(((AtomixValueEndpoint)((Object)this.getAtomixEndpoint())).getConfiguration().getResourceConfig(resourceName))).join();
    }
}

