/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atom;

import java.util.Date;
import org.apache.abdera.model.Entry;
import org.apache.camel.component.feed.EntryFilter;
import org.apache.camel.spi.annotations.JdkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JdkService(value="adapter-factory")
public class UpdatedDateFilter
implements EntryFilter<Entry> {
    private static final Logger LOG = LoggerFactory.getLogger(UpdatedDateFilter.class);
    private Date lastUpdate;

    public UpdatedDateFilter() {
    }

    public UpdatedDateFilter(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    @Override
    public boolean isValidEntry(Entry entry) {
        Date updated = entry.getUpdated();
        if (updated == null) {
            updated = entry.getPublished();
        }
        if (updated == null) {
            LOG.debug("No updated time for entry so assuming its valid: entry=[{}]", (Object)entry);
            return true;
        }
        if (this.lastUpdate != null && (this.lastUpdate.after(updated) || this.lastUpdate.equals(updated))) {
            LOG.debug("Entry is older than last update=[{}], no valid entry=[{}]", (Object)this.lastUpdate, (Object)entry);
            return false;
        }
        this.lastUpdate = updated;
        return true;
    }
}

