/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atmosphere.websocket;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import org.apache.camel.component.atmosphere.websocket.WebsocketConsumer;
import org.apache.camel.component.servlet.CamelHttpTransportServlet;
import org.apache.camel.http.common.HttpConsumer;

public class CamelWebSocketServlet
extends CamelHttpTransportServlet {
    private static final long serialVersionUID = 1764707448550670635L;
    private static final String RESEND_ALL_WEBSOCKET_EVENTS_PARAM_KEY = "events";
    private boolean enableEventsResending;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.initParameters(config);
        this.enrichConsumers(config);
    }

    protected void doService(HttpServletRequest request, HttpServletResponse response) {
        this.log.trace("Service: {}", (Object)request);
        try {
            this.handleDoService(request, response);
        }
        catch (Exception e) {
            this.log.warn("Error handling request due to: {}", (Object)e.getMessage(), (Object)e);
            try {
                if (!response.isCommitted()) {
                    response.sendError(500);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void handleDoService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpConsumer consumer = this.getServletResolveConsumerStrategy().resolve(request, this.getConsumers());
        if (consumer == null) {
            this.log.debug("No consumer to service request {}", (Object)request);
            response.sendError(404);
            return;
        }
        if (consumer.isSuspended()) {
            this.log.debug("Consumer suspended, cannot service request {}", (Object)request);
            response.sendError(503);
            return;
        }
        if (consumer.getEndpoint().getHttpMethodRestrict() != null && !consumer.getEndpoint().getHttpMethodRestrict().equals(request.getMethod())) {
            response.sendError(405);
            return;
        }
        if ("TRACE".equals(request.getMethod()) && !consumer.isTraceEnabled()) {
            response.sendError(405);
            return;
        }
        if (!(consumer instanceof WebsocketConsumer)) {
            this.log.debug("Consumer not supporting websocket {}", (Object)request);
            response.sendError(503);
            return;
        }
        this.log.debug("Dispatching to Websocket Consumer at {}", (Object)consumer.getPath());
        ((WebsocketConsumer)consumer).service(request, response);
    }

    private void initParameters(ServletConfig config) {
        String eventsResendingParameter = config.getInitParameter(RESEND_ALL_WEBSOCKET_EVENTS_PARAM_KEY);
        if ("true".equals(eventsResendingParameter)) {
            this.log.debug("Events resending enabled");
            this.enableEventsResending = true;
        }
    }

    private void enrichConsumers(ServletConfig config) throws ServletException {
        for (Map.Entry httpConsumerEntry : this.getConsumers().entrySet()) {
            WebsocketConsumer consumer = (WebsocketConsumer)((Object)httpConsumerEntry.getValue());
            consumer.configureFramework(config);
            consumer.configureEventsResending(this.enableEventsResending);
        }
    }
}

