/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atmos.integration.consumer;

import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.atmos.AtmosConfiguration;
import org.apache.camel.component.atmos.AtmosEndpoint;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AtmosScheduledPollConsumer
extends ScheduledPollConsumer {
    protected static final transient Logger LOG = LoggerFactory.getLogger(AtmosScheduledPollConsumer.class);
    protected AtmosEndpoint endpoint;
    protected AtmosConfiguration configuration;

    public AtmosScheduledPollConsumer(AtmosEndpoint endpoint, Processor processor, AtmosConfiguration configuration) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.configuration = configuration;
    }

    protected abstract int poll() throws Exception;

    protected void doStart() throws Exception {
        if (this.configuration.getClient() == null) {
            this.configuration.createClient();
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.configuration.getClient() != null) {
            this.configuration.setClient(null);
        }
        super.doStop();
    }
}

