/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2;

import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.time.Duration;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.camel.CamelContext;
import org.apache.camel.component.as2.AS2Configuration;
import org.apache.camel.component.as2.api.AS2CompressionAlgorithm;
import org.apache.camel.component.as2.api.AS2EncryptionAlgorithm;
import org.apache.camel.component.as2.api.AS2MessageStructure;
import org.apache.camel.component.as2.api.AS2SignatureAlgorithm;
import org.apache.camel.component.as2.internal.AS2ApiName;
import org.apache.camel.spi.ExtendedPropertyConfigurerGetter;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;
import org.apache.http.entity.ContentType;

public class AS2ConfigurationConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
ExtendedPropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        AS2Configuration target = (AS2Configuration)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "apiname": 
            case "apiName": {
                target.setApiName((AS2ApiName)((Object)AS2ConfigurationConfigurer.property((CamelContext)camelContext, AS2ApiName.class, (Object)value)));
                return true;
            }
            case "as2from": 
            case "as2From": {
                target.setAs2From((String)AS2ConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "as2messagestructure": 
            case "as2MessageStructure": {
                target.setAs2MessageStructure((AS2MessageStructure)AS2ConfigurationConfigurer.property((CamelContext)camelContext, AS2MessageStructure.class, (Object)value));
                return true;
            }
            case "as2to": 
            case "as2To": {
                target.setAs2To((String)AS2ConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "as2version": 
            case "as2Version": {
                target.setAs2Version((String)AS2ConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "attachedfilename": 
            case "attachedFileName": {
                target.setAttachedFileName((String)AS2ConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "clientfqdn": 
            case "clientFqdn": {
                target.setClientFqdn((String)AS2ConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "compressionalgorithm": 
            case "compressionAlgorithm": {
                target.setCompressionAlgorithm((AS2CompressionAlgorithm)AS2ConfigurationConfigurer.property((CamelContext)camelContext, AS2CompressionAlgorithm.class, (Object)value));
                return true;
            }
            case "decryptingprivatekey": 
            case "decryptingPrivateKey": {
                target.setDecryptingPrivateKey((PrivateKey)AS2ConfigurationConfigurer.property((CamelContext)camelContext, PrivateKey.class, (Object)value));
                return true;
            }
            case "dispositionnotificationto": 
            case "dispositionNotificationTo": {
                target.setDispositionNotificationTo((String)AS2ConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "edimessagetransferencoding": 
            case "ediMessageTransferEncoding": {
                target.setEdiMessageTransferEncoding((String)AS2ConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "edimessagetype": 
            case "ediMessageType": {
                target.setEdiMessageType((ContentType)AS2ConfigurationConfigurer.property((CamelContext)camelContext, ContentType.class, (Object)value));
                return true;
            }
            case "encryptingalgorithm": 
            case "encryptingAlgorithm": {
                target.setEncryptingAlgorithm((AS2EncryptionAlgorithm)AS2ConfigurationConfigurer.property((CamelContext)camelContext, AS2EncryptionAlgorithm.class, (Object)value));
                return true;
            }
            case "encryptingcertificatechain": 
            case "encryptingCertificateChain": {
                target.setEncryptingCertificateChain((Certificate[])AS2ConfigurationConfigurer.property((CamelContext)camelContext, Certificate[].class, (Object)value));
                return true;
            }
            case "from": {
                target.setFrom((String)AS2ConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "hostnameverifier": 
            case "hostnameVerifier": {
                target.setHostnameVerifier((HostnameVerifier)AS2ConfigurationConfigurer.property((CamelContext)camelContext, HostnameVerifier.class, (Object)value));
                return true;
            }
            case "httpconnectionpoolsize": 
            case "httpConnectionPoolSize": {
                target.setHttpConnectionPoolSize((Integer)AS2ConfigurationConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "httpconnectionpoolttl": 
            case "httpConnectionPoolTtl": {
                target.setHttpConnectionPoolTtl((Duration)AS2ConfigurationConfigurer.property((CamelContext)camelContext, Duration.class, (Object)value));
                return true;
            }
            case "httpconnectiontimeout": 
            case "httpConnectionTimeout": {
                target.setHttpConnectionTimeout((Duration)AS2ConfigurationConfigurer.property((CamelContext)camelContext, Duration.class, (Object)value));
                return true;
            }
            case "httpsockettimeout": 
            case "httpSocketTimeout": {
                target.setHttpSocketTimeout((Duration)AS2ConfigurationConfigurer.property((CamelContext)camelContext, Duration.class, (Object)value));
                return true;
            }
            case "mdnmessagetemplate": 
            case "mdnMessageTemplate": {
                target.setMdnMessageTemplate((String)AS2ConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "methodname": 
            case "methodName": {
                target.setMethodName((String)AS2ConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "requesturi": 
            case "requestUri": {
                target.setRequestUri((String)AS2ConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "server": {
                target.setServer((String)AS2ConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "serverfqdn": 
            case "serverFqdn": {
                target.setServerFqdn((String)AS2ConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "serverportnumber": 
            case "serverPortNumber": {
                target.setServerPortNumber((Integer)AS2ConfigurationConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "signedreceiptmicalgorithms": 
            case "signedReceiptMicAlgorithms": {
                target.setSignedReceiptMicAlgorithms((String[])AS2ConfigurationConfigurer.property((CamelContext)camelContext, String[].class, (Object)value));
                return true;
            }
            case "signingalgorithm": 
            case "signingAlgorithm": {
                target.setSigningAlgorithm((AS2SignatureAlgorithm)AS2ConfigurationConfigurer.property((CamelContext)camelContext, AS2SignatureAlgorithm.class, (Object)value));
                return true;
            }
            case "signingcertificatechain": 
            case "signingCertificateChain": {
                target.setSigningCertificateChain((Certificate[])AS2ConfigurationConfigurer.property((CamelContext)camelContext, Certificate[].class, (Object)value));
                return true;
            }
            case "signingprivatekey": 
            case "signingPrivateKey": {
                target.setSigningPrivateKey((PrivateKey)AS2ConfigurationConfigurer.property((CamelContext)camelContext, PrivateKey.class, (Object)value));
                return true;
            }
            case "sslcontext": 
            case "sslContext": {
                target.setSslContext((SSLContext)AS2ConfigurationConfigurer.property((CamelContext)camelContext, SSLContext.class, (Object)value));
                return true;
            }
            case "subject": {
                target.setSubject((String)AS2ConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "targethostname": 
            case "targetHostname": {
                target.setTargetHostname((String)AS2ConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "targetportnumber": 
            case "targetPortNumber": {
                target.setTargetPortNumber((Integer)AS2ConfigurationConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "useragent": 
            case "userAgent": {
                target.setUserAgent((String)AS2ConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "validatesigningcertificatechain": 
            case "validateSigningCertificateChain": {
                target.setValidateSigningCertificateChain((Certificate[])AS2ConfigurationConfigurer.property((CamelContext)camelContext, Certificate[].class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "apiname": 
            case "apiName": {
                return AS2ApiName.class;
            }
            case "as2from": 
            case "as2From": {
                return String.class;
            }
            case "as2messagestructure": 
            case "as2MessageStructure": {
                return AS2MessageStructure.class;
            }
            case "as2to": 
            case "as2To": {
                return String.class;
            }
            case "as2version": 
            case "as2Version": {
                return String.class;
            }
            case "attachedfilename": 
            case "attachedFileName": {
                return String.class;
            }
            case "clientfqdn": 
            case "clientFqdn": {
                return String.class;
            }
            case "compressionalgorithm": 
            case "compressionAlgorithm": {
                return AS2CompressionAlgorithm.class;
            }
            case "decryptingprivatekey": 
            case "decryptingPrivateKey": {
                return PrivateKey.class;
            }
            case "dispositionnotificationto": 
            case "dispositionNotificationTo": {
                return String.class;
            }
            case "edimessagetransferencoding": 
            case "ediMessageTransferEncoding": {
                return String.class;
            }
            case "edimessagetype": 
            case "ediMessageType": {
                return ContentType.class;
            }
            case "encryptingalgorithm": 
            case "encryptingAlgorithm": {
                return AS2EncryptionAlgorithm.class;
            }
            case "encryptingcertificatechain": 
            case "encryptingCertificateChain": {
                return Certificate[].class;
            }
            case "from": {
                return String.class;
            }
            case "hostnameverifier": 
            case "hostnameVerifier": {
                return HostnameVerifier.class;
            }
            case "httpconnectionpoolsize": 
            case "httpConnectionPoolSize": {
                return Integer.class;
            }
            case "httpconnectionpoolttl": 
            case "httpConnectionPoolTtl": {
                return Duration.class;
            }
            case "httpconnectiontimeout": 
            case "httpConnectionTimeout": {
                return Duration.class;
            }
            case "httpsockettimeout": 
            case "httpSocketTimeout": {
                return Duration.class;
            }
            case "mdnmessagetemplate": 
            case "mdnMessageTemplate": {
                return String.class;
            }
            case "methodname": 
            case "methodName": {
                return String.class;
            }
            case "requesturi": 
            case "requestUri": {
                return String.class;
            }
            case "server": {
                return String.class;
            }
            case "serverfqdn": 
            case "serverFqdn": {
                return String.class;
            }
            case "serverportnumber": 
            case "serverPortNumber": {
                return Integer.class;
            }
            case "signedreceiptmicalgorithms": 
            case "signedReceiptMicAlgorithms": {
                return String[].class;
            }
            case "signingalgorithm": 
            case "signingAlgorithm": {
                return AS2SignatureAlgorithm.class;
            }
            case "signingcertificatechain": 
            case "signingCertificateChain": {
                return Certificate[].class;
            }
            case "signingprivatekey": 
            case "signingPrivateKey": {
                return PrivateKey.class;
            }
            case "sslcontext": 
            case "sslContext": {
                return SSLContext.class;
            }
            case "subject": {
                return String.class;
            }
            case "targethostname": 
            case "targetHostname": {
                return String.class;
            }
            case "targetportnumber": 
            case "targetPortNumber": {
                return Integer.class;
            }
            case "useragent": 
            case "userAgent": {
                return String.class;
            }
            case "validatesigningcertificatechain": 
            case "validateSigningCertificateChain": {
                return Certificate[].class;
            }
        }
        return null;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        AS2Configuration target = (AS2Configuration)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "apiname": 
            case "apiName": {
                return target.getApiName();
            }
            case "as2from": 
            case "as2From": {
                return target.getAs2From();
            }
            case "as2messagestructure": 
            case "as2MessageStructure": {
                return target.getAs2MessageStructure();
            }
            case "as2to": 
            case "as2To": {
                return target.getAs2To();
            }
            case "as2version": 
            case "as2Version": {
                return target.getAs2Version();
            }
            case "attachedfilename": 
            case "attachedFileName": {
                return target.getAttachedFileName();
            }
            case "clientfqdn": 
            case "clientFqdn": {
                return target.getClientFqdn();
            }
            case "compressionalgorithm": 
            case "compressionAlgorithm": {
                return target.getCompressionAlgorithm();
            }
            case "decryptingprivatekey": 
            case "decryptingPrivateKey": {
                return target.getDecryptingPrivateKey();
            }
            case "dispositionnotificationto": 
            case "dispositionNotificationTo": {
                return target.getDispositionNotificationTo();
            }
            case "edimessagetransferencoding": 
            case "ediMessageTransferEncoding": {
                return target.getEdiMessageTransferEncoding();
            }
            case "edimessagetype": 
            case "ediMessageType": {
                return target.getEdiMessageType();
            }
            case "encryptingalgorithm": 
            case "encryptingAlgorithm": {
                return target.getEncryptingAlgorithm();
            }
            case "encryptingcertificatechain": 
            case "encryptingCertificateChain": {
                return target.getEncryptingCertificateChain();
            }
            case "from": {
                return target.getFrom();
            }
            case "hostnameverifier": 
            case "hostnameVerifier": {
                return target.getHostnameVerifier();
            }
            case "httpconnectionpoolsize": 
            case "httpConnectionPoolSize": {
                return target.getHttpConnectionPoolSize();
            }
            case "httpconnectionpoolttl": 
            case "httpConnectionPoolTtl": {
                return target.getHttpConnectionPoolTtl();
            }
            case "httpconnectiontimeout": 
            case "httpConnectionTimeout": {
                return target.getHttpConnectionTimeout();
            }
            case "httpsockettimeout": 
            case "httpSocketTimeout": {
                return target.getHttpSocketTimeout();
            }
            case "mdnmessagetemplate": 
            case "mdnMessageTemplate": {
                return target.getMdnMessageTemplate();
            }
            case "methodname": 
            case "methodName": {
                return target.getMethodName();
            }
            case "requesturi": 
            case "requestUri": {
                return target.getRequestUri();
            }
            case "server": {
                return target.getServer();
            }
            case "serverfqdn": 
            case "serverFqdn": {
                return target.getServerFqdn();
            }
            case "serverportnumber": 
            case "serverPortNumber": {
                return target.getServerPortNumber();
            }
            case "signedreceiptmicalgorithms": 
            case "signedReceiptMicAlgorithms": {
                return target.getSignedReceiptMicAlgorithms();
            }
            case "signingalgorithm": 
            case "signingAlgorithm": {
                return target.getSigningAlgorithm();
            }
            case "signingcertificatechain": 
            case "signingCertificateChain": {
                return target.getSigningCertificateChain();
            }
            case "signingprivatekey": 
            case "signingPrivateKey": {
                return target.getSigningPrivateKey();
            }
            case "sslcontext": 
            case "sslContext": {
                return target.getSslContext();
            }
            case "subject": {
                return target.getSubject();
            }
            case "targethostname": 
            case "targetHostname": {
                return target.getTargetHostname();
            }
            case "targetportnumber": 
            case "targetPortNumber": {
                return target.getTargetPortNumber();
            }
            case "useragent": 
            case "userAgent": {
                return target.getUserAgent();
            }
            case "validatesigningcertificatechain": 
            case "validateSigningCertificateChain": {
                return target.getValidateSigningCertificateChain();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("ApiName", AS2ApiName.class);
        map.put("As2From", String.class);
        map.put("As2MessageStructure", AS2MessageStructure.class);
        map.put("As2To", String.class);
        map.put("As2Version", String.class);
        map.put("AttachedFileName", String.class);
        map.put("ClientFqdn", String.class);
        map.put("CompressionAlgorithm", AS2CompressionAlgorithm.class);
        map.put("DecryptingPrivateKey", PrivateKey.class);
        map.put("DispositionNotificationTo", String.class);
        map.put("EdiMessageTransferEncoding", String.class);
        map.put("EdiMessageType", ContentType.class);
        map.put("EncryptingAlgorithm", AS2EncryptionAlgorithm.class);
        map.put("EncryptingCertificateChain", Certificate[].class);
        map.put("From", String.class);
        map.put("HostnameVerifier", HostnameVerifier.class);
        map.put("HttpConnectionPoolSize", Integer.class);
        map.put("HttpConnectionPoolTtl", Duration.class);
        map.put("HttpConnectionTimeout", Duration.class);
        map.put("HttpSocketTimeout", Duration.class);
        map.put("MdnMessageTemplate", String.class);
        map.put("MethodName", String.class);
        map.put("RequestUri", String.class);
        map.put("Server", String.class);
        map.put("ServerFqdn", String.class);
        map.put("ServerPortNumber", Integer.class);
        map.put("SignedReceiptMicAlgorithms", String[].class);
        map.put("SigningAlgorithm", AS2SignatureAlgorithm.class);
        map.put("SigningCertificateChain", Certificate[].class);
        map.put("SigningPrivateKey", PrivateKey.class);
        map.put("SslContext", SSLContext.class);
        map.put("Subject", String.class);
        map.put("TargetHostname", String.class);
        map.put("TargetPortNumber", Integer.class);
        map.put("UserAgent", String.class);
        map.put("ValidateSigningCertificateChain", Certificate[].class);
        ALL_OPTIONS = map;
    }
}

