/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2;

import java.io.IOException;
import java.net.UnknownHostException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.as2.AS2Component;
import org.apache.camel.component.as2.AS2Configuration;
import org.apache.camel.component.as2.AS2Consumer;
import org.apache.camel.component.as2.AS2Producer;
import org.apache.camel.component.as2.api.AS2ClientConnection;
import org.apache.camel.component.as2.api.AS2ClientManager;
import org.apache.camel.component.as2.api.AS2CompressionAlgorithm;
import org.apache.camel.component.as2.api.AS2EncryptionAlgorithm;
import org.apache.camel.component.as2.api.AS2MessageStructure;
import org.apache.camel.component.as2.api.AS2ServerConnection;
import org.apache.camel.component.as2.api.AS2ServerManager;
import org.apache.camel.component.as2.api.AS2SignatureAlgorithm;
import org.apache.camel.component.as2.internal.AS2ApiCollection;
import org.apache.camel.component.as2.internal.AS2ApiName;
import org.apache.camel.component.as2.internal.AS2ConnectionHelper;
import org.apache.camel.component.as2.internal.AS2PropertiesHelper;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.component.AbstractApiEndpoint;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodPropertiesHelper;
import org.apache.camel.support.component.ApiName;
import org.apache.http.entity.ContentType;

@UriEndpoint(scheme="as2", firstVersion="2.22.0", title="AS2", syntax="as2:apiName/methodName", apiSyntax="apiName/methodName", category={Category.FILE})
@Metadata(excludeProperties="startScheduler,initialDelay,delay,timeUnit,useFixedDelay,pollStrategy,runLoggingLevel,sendEmptyMessageWhenIdle,greedy,scheduler,schedulerProperties,scheduledExecutorService,backoffMultiplier,backoffIdleThreshold,backoffErrorThreshold,repeatCount,bridgeErrorHandler")
public class AS2Endpoint
extends AbstractApiEndpoint<AS2ApiName, AS2Configuration> {
    @UriParam
    private AS2Configuration configuration;
    private Object apiProxy;
    private AS2ClientConnection as2ClientConnection;
    private AS2ServerConnection as2ServerConnection;

    public AS2Endpoint(String uri, AS2Component component, AS2ApiName apiName, String methodName, AS2Configuration endpointConfiguration) {
        super(uri, (Component)component, (ApiName)apiName, methodName, AS2ApiCollection.getCollection().getHelper(apiName), (Object)endpointConfiguration);
        this.configuration = endpointConfiguration;
    }

    public AS2ClientConnection getAS2ClientConnection() {
        return this.as2ClientConnection;
    }

    public AS2ServerConnection getAS2ServerConnection() {
        return this.as2ServerConnection;
    }

    public Producer createProducer() throws Exception {
        return new AS2Producer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (this.inBody != null) {
            throw new IllegalArgumentException("Option inBody is not supported for consumer endpoint");
        }
        AS2Consumer consumer = new AS2Consumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public String getRequestUri() {
        return this.configuration.getRequestUri();
    }

    public void setRequestUri(String requestUri) {
        this.configuration.setRequestUri(requestUri);
    }

    public String getSubject() {
        return this.configuration.getSubject();
    }

    public void setSubject(String subject) {
        this.configuration.setSubject(subject);
    }

    public String getFrom() {
        return this.configuration.getFrom();
    }

    public void setFrom(String from) {
        this.configuration.setFrom(from);
    }

    public String getAs2From() {
        return this.configuration.getAs2From();
    }

    public void setAs2From(String as2From) {
        this.configuration.setAs2From(as2From);
    }

    public String getAs2To() {
        return this.configuration.getAs2To();
    }

    public void setAs2To(String as2To) {
        this.configuration.setAs2To(as2To);
    }

    public AS2MessageStructure getAs2MessageStructure() {
        return this.configuration.getAs2MessageStructure();
    }

    public void setAs2MessageStructure(AS2MessageStructure as2MessageStructure) {
        this.configuration.setAs2MessageStructure(as2MessageStructure);
    }

    public ContentType getEdiMessageType() {
        return this.configuration.getEdiMessageType();
    }

    public void setEdiMessageContentType(ContentType ediMessageType) {
        this.configuration.setEdiMessageType(ediMessageType);
    }

    public String getEdiMessageTransferEncoding() {
        return this.configuration.getEdiMessageTransferEncoding();
    }

    public void setEdiMessageTransferEncoding(String ediMessageTransferEncoding) {
        this.configuration.setEdiMessageTransferEncoding(ediMessageTransferEncoding);
    }

    public AS2SignatureAlgorithm getSigningAlgorithm() {
        return this.configuration.getSigningAlgorithm();
    }

    public void setSigningAlgorithm(AS2SignatureAlgorithm signingAlgorithm) {
        this.configuration.setSigningAlgorithm(signingAlgorithm);
    }

    public Certificate[] getSigningCertificateChain() {
        return this.configuration.getSigningCertificateChain();
    }

    public void setSigningCertificateChain(Certificate[] signingCertificateChain) {
        this.configuration.setSigningCertificateChain(signingCertificateChain);
    }

    public PrivateKey getSigningPrivateKey() {
        return this.configuration.getSigningPrivateKey();
    }

    public void setSigningPrivateKey(PrivateKey signingPrivateKey) {
        this.configuration.setSigningPrivateKey(signingPrivateKey);
    }

    public AS2CompressionAlgorithm getCompressionAlgorithm() {
        return this.configuration.getCompressionAlgorithm();
    }

    public void setCompressionAlgorithm(AS2CompressionAlgorithm compressionAlgorithm) {
        this.configuration.setCompressionAlgorithm(compressionAlgorithm);
    }

    public String getDispositionNotificationTo() {
        return this.configuration.getDispositionNotificationTo();
    }

    public void setDispositionNotificationTo(String dispositionNotificationTo) {
        this.configuration.setDispositionNotificationTo(dispositionNotificationTo);
    }

    public String[] getSignedReceiptMicAlgorithms() {
        return this.configuration.getSignedReceiptMicAlgorithms();
    }

    public void setSignedReceiptMicAlgorithms(String[] signedReceiptMicAlgorithms) {
        this.configuration.setSignedReceiptMicAlgorithms(signedReceiptMicAlgorithms);
    }

    public AS2EncryptionAlgorithm getEncryptingAlgorithm() {
        return this.configuration.getEncryptingAlgorithm();
    }

    public void setEncryptingAlgorithm(AS2EncryptionAlgorithm encryptingAlgorithm) {
        this.configuration.setEncryptingAlgorithm(encryptingAlgorithm);
    }

    public Certificate[] getEncryptingCertificateChain() {
        return this.configuration.getEncryptingCertificateChain();
    }

    public void setEncryptingCertificateChain(Certificate[] encryptingCertificateChain) {
        this.configuration.setEncryptingCertificateChain(encryptingCertificateChain);
    }

    protected ApiMethodPropertiesHelper<AS2Configuration> getPropertiesHelper() {
        return AS2PropertiesHelper.getHelper(this.getCamelContext());
    }

    protected String getThreadProfileName() {
        return "CamelAS2";
    }

    protected void afterConfigureProperties() {
        switch ((AS2ApiName)this.apiName) {
            case CLIENT: {
                this.createAS2ClientConnection();
                break;
            }
            case SERVER: {
                this.createAS2ServerConnection();
                break;
            }
        }
    }

    public Object getApiProxy(ApiMethod method, Map<String, Object> args) {
        if (this.apiProxy == null) {
            this.createApiProxy();
        }
        return this.apiProxy;
    }

    private void createApiProxy() {
        switch ((AS2ApiName)this.apiName) {
            case CLIENT: {
                this.apiProxy = new AS2ClientManager(this.getAS2ClientConnection());
                break;
            }
            case SERVER: {
                this.apiProxy = new AS2ServerManager(this.getAS2ServerConnection());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid API name " + this.apiName);
            }
        }
    }

    private void createAS2ClientConnection() {
        try {
            this.as2ClientConnection = AS2ConnectionHelper.createAS2ClientConnection(this.configuration);
        }
        catch (UnknownHostException e) {
            throw new RuntimeCamelException(String.format("Client HTTP connection failed: Unknown target host '%s'", this.configuration.getTargetHostname()));
        }
        catch (IOException e) {
            throw new RuntimeCamelException("Client HTTP connection failed", (Throwable)e);
        }
    }

    private void createAS2ServerConnection() {
        try {
            this.as2ServerConnection = AS2ConnectionHelper.createAS2ServerConnection(this.configuration);
        }
        catch (IOException e) {
            throw new RuntimeCamelException("Server HTTP connection failed", (Throwable)e);
        }
    }
}

