/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Processor;
import org.apache.camel.component.as2.AS2Configuration;
import org.apache.camel.component.as2.AS2Endpoint;
import org.apache.camel.component.as2.api.AS2ServerConnection;
import org.apache.camel.component.as2.api.AS2ServerManager;
import org.apache.camel.component.as2.api.entity.EntityParser;
import org.apache.camel.component.as2.internal.AS2ApiName;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.util.component.AbstractApiConsumer;
import org.apache.camel.util.component.AbstractApiEndpoint;
import org.apache.camel.util.component.ApiConsumerHelper;
import org.apache.camel.util.component.ApiMethod;
import org.apache.camel.util.component.ApiMethodHelper;
import org.apache.camel.util.component.PropertyNamesInterceptor;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

public class AS2Consumer
extends AbstractApiConsumer<AS2ApiName, AS2Configuration>
implements HttpRequestHandler {
    private static final String HANDLER_PROPERTY = "handler";
    private static final String REQUEST_URI_PROPERTY = "requestUri";
    private AS2ServerConnection as2ServerConnection;
    private AS2ServerManager apiProxy;
    private final ApiMethod apiMethod;
    private final Map<String, Object> properties;

    public AS2Consumer(AS2Endpoint endpoint, Processor processor) {
        super((AbstractApiEndpoint)endpoint, processor);
        this.apiMethod = ApiConsumerHelper.findMethod((AbstractApiEndpoint)endpoint, (PropertyNamesInterceptor)this);
        this.properties = new HashMap<String, Object>();
        this.properties.putAll(endpoint.getEndpointProperties());
        this.properties.put(HANDLER_PROPERTY, (Object)this);
        this.as2ServerConnection = endpoint.getAS2ServerConnection();
        this.apiProxy = new AS2ServerManager(this.as2ServerConnection);
    }

    public void interceptPropertyNames(Set<String> propertyNames) {
        propertyNames.add(HANDLER_PROPERTY);
    }

    protected int poll() throws Exception {
        return 0;
    }

    protected void doStart() throws Exception {
        super.doStart();
        ApiMethodHelper.invokeMethod((Object)this.apiProxy, (ApiMethod)this.apiMethod, this.properties);
    }

    protected void doStop() throws Exception {
        String requestUri = (String)this.properties.get(REQUEST_URI_PROPERTY);
        this.apiProxy.stopListening(requestUri);
        super.doStop();
    }

    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        try {
            if (request instanceof HttpEntityEnclosingRequest) {
                EntityParser.parseAS2MessageEntity((HttpMessage)request);
                this.apiProxy.handleMDNResponse((HttpEntityEnclosingRequest)request, response, context, "MDN Response", "Camel AS2 Server Endpoint");
            }
            this.log.debug("Processed {} event for {}", (Object)ApiConsumerHelper.getResultsProcessed((DefaultConsumer)this, (Object)context, (boolean)false), (Object)this.as2ServerConnection);
        }
        catch (Exception e) {
            this.log.info("Received exception consuming AS2 message: ", (Throwable)e);
        }
    }
}

