/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api;

import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.apache.camel.component.as2.api.entity.MultipartMimeEntity;
import org.apache.camel.component.as2.api.protocol.RequestAsynchronousMDN;
import org.apache.camel.component.as2.api.util.EntityUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.hc.client5.http.impl.io.ManagedHttpClientConnectionFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import org.apache.hc.core5.http.io.HttpClientConnection;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http.protocol.HttpProcessorBuilder;
import org.apache.hc.core5.http.protocol.RequestConnControl;
import org.apache.hc.core5.http.protocol.RequestContent;
import org.apache.hc.core5.http.protocol.RequestDate;
import org.apache.hc.core5.http.protocol.RequestExpectContinue;
import org.apache.hc.core5.http.protocol.RequestTargetHost;
import org.apache.hc.core5.http.protocol.RequestUserAgent;

public class AS2AsynchronousMDNManager {
    public static final String CAMEL_AS2_ASYNC_MDN_PREFIX = "camel-as2.async-mdn.";
    public static final String HTTP_REQUEST = "http.request";
    public static final String HTTP_RESPONSE = "http.response";
    public static final String AS2_CONNECTION = "camel-as2.async-mdn.as2-connection";
    public static final String RECIPIENT_ADDRESS = "camel-as2.async-mdn.recipient-address";
    public static final String ASYNCHRONOUS_MDN = "camel-as2.async-mdn.asynchronous-mdn";
    private HttpProcessor httpProcessor;
    private Certificate[] signingCertificateChain;
    private PrivateKey signingPrivateKey;

    public AS2AsynchronousMDNManager(String as2Version, String userAgent, String senderFQDN, Certificate[] signingCertificateChain, PrivateKey signingPrivateKey) {
        this.signingCertificateChain = signingCertificateChain;
        this.signingPrivateKey = signingPrivateKey;
        this.httpProcessor = HttpProcessorBuilder.create().add((HttpRequestInterceptor)new RequestAsynchronousMDN(as2Version, senderFQDN)).add((HttpRequestInterceptor)new RequestTargetHost()).add((HttpRequestInterceptor)new RequestUserAgent(userAgent)).add((HttpRequestInterceptor)new RequestDate()).add((HttpRequestInterceptor)new RequestContent(true)).add((HttpRequestInterceptor)new RequestConnControl()).add((HttpRequestInterceptor)new RequestExpectContinue()).build();
    }

    public HttpCoreContext send(MultipartMimeEntity multipartMimeEntity, String contentType, String recipientDeliveryAddress) throws HttpException {
        HttpCoreContext httpCoreContext;
        block10: {
            ObjectHelper.notNull((Object)((Object)multipartMimeEntity), (String)"multipartMimeEntity");
            ObjectHelper.notNull((Object)contentType, (String)"contentType");
            ObjectHelper.notNull((Object)recipientDeliveryAddress, (String)"recipientDeliveryAddress");
            URI uri = URI.create(recipientDeliveryAddress);
            int buffSize = 8192;
            Http1Config h1Config = Http1Config.custom().setBufferSize(buffSize).build();
            ManagedHttpClientConnectionFactory connFactory = ManagedHttpClientConnectionFactory.builder().http1Config(h1Config).build();
            HttpClientConnection httpConnection = (HttpClientConnection)connFactory.createConnection(new Socket(uri.getHost(), uri.getPort()));
            try {
                HttpResponse response;
                HttpCoreContext httpContext = HttpCoreContext.create();
                httpContext.setAttribute(RECIPIENT_ADDRESS, (Object)recipientDeliveryAddress);
                BasicClassicHttpRequest request = new BasicClassicHttpRequest("POST", uri);
                request.setHeader("Content-Type", (Object)contentType);
                httpContext.setAttribute(HTTP_REQUEST, (Object)request);
                multipartMimeEntity.setMainBody(true);
                EntityUtils.setMessageEntity((HttpMessage)request, (HttpEntity)multipartMimeEntity);
                try {
                    httpContext.setAttribute(AS2_CONNECTION, (Object)httpConnection);
                    response = this.send(httpConnection, (ClassicHttpRequest)request, httpContext);
                }
                catch (IOException e) {
                    throw new HttpException("Failed to send http request message", (Throwable)e);
                }
                httpContext.setAttribute(HTTP_RESPONSE, (Object)response);
                httpCoreContext = httpContext;
                if (httpConnection == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (httpConnection != null) {
                        try {
                            httpConnection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new HttpException("failed to send MDN", (Throwable)e);
                }
            }
            httpConnection.close();
        }
        return httpCoreContext;
    }

    private HttpResponse send(HttpClientConnection httpConnection, ClassicHttpRequest request, HttpCoreContext httpContext) throws HttpException, IOException {
        HttpRequestExecutor httpExecutor = new HttpRequestExecutor();
        httpExecutor.preProcess(request, this.httpProcessor, (HttpContext)httpContext);
        ClassicHttpResponse response = httpExecutor.execute(request, httpConnection, (HttpContext)httpContext);
        httpExecutor.postProcess(response, this.httpProcessor, (HttpContext)httpContext);
        return response;
    }
}

