/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.camel.component.as2.api.AS2AsynchronousMDNManager;
import org.apache.camel.component.as2.api.AS2SignatureAlgorithm;
import org.apache.camel.component.as2.api.AS2SignedDataGenerator;
import org.apache.camel.component.as2.api.entity.DispositionNotificationMultipartReportEntity;
import org.apache.camel.component.as2.api.entity.MultipartSignedEntity;
import org.apache.camel.component.as2.api.io.AS2BHttpServerConnection;
import org.apache.camel.component.as2.api.protocol.ResponseMDN;
import org.apache.camel.util.ObjectHelper;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestMapper;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.io.HttpService;
import org.apache.hc.core5.http.io.HttpRequestHandler;
import org.apache.hc.core5.http.io.HttpServerConnection;
import org.apache.hc.core5.http.io.HttpServerRequestHandler;
import org.apache.hc.core5.http.io.support.BasicHttpServerRequestHandler;
import org.apache.hc.core5.http.protocol.BasicHttpContext;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http.protocol.HttpProcessorBuilder;
import org.apache.hc.core5.http.protocol.RequestHandlerRegistry;
import org.apache.hc.core5.http.protocol.ResponseConnControl;
import org.apache.hc.core5.http.protocol.ResponseContent;
import org.apache.hc.core5.http.protocol.ResponseDate;
import org.apache.hc.core5.http.protocol.ResponseServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS2ServerConnection {
    private static final Logger LOG = LoggerFactory.getLogger(AS2ServerConnection.class);
    private static final String REQUEST_LISTENER_THREAD_NAME_PREFIX = "AS2Svr-";
    private static final String REQUEST_HANDLER_THREAD_NAME_PREFIX = "AS2Hdlr-";
    private RequestListenerThread listenerThread;
    private final Object lock = new Object();
    private final String as2Version;
    private final String originServer;
    private final String serverFqdn;
    private final Certificate[] signingCertificateChain;
    private final PrivateKey signingPrivateKey;
    private final PrivateKey decryptingPrivateKey;
    private final Certificate[] validateSigningCertificateChain;
    private final AS2SignatureAlgorithm signingAlgorithm;

    public AS2ServerConnection(String as2Version, String originServer, String serverFqdn, Integer serverPortNumber, AS2SignatureAlgorithm signingAlgorithm, Certificate[] signingCertificateChain, PrivateKey signingPrivateKey, PrivateKey decryptingPrivateKey, String mdnMessageTemplate, Certificate[] validateSigningCertificateChain, SSLContext sslContext) throws IOException {
        this.as2Version = (String)ObjectHelper.notNull((Object)as2Version, (String)"as2Version");
        this.originServer = (String)ObjectHelper.notNull((Object)originServer, (String)"userAgent");
        this.serverFqdn = (String)ObjectHelper.notNull((Object)serverFqdn, (String)"serverFqdn");
        Integer parserServerPortNumber = (Integer)ObjectHelper.notNull((Object)serverPortNumber, (String)"serverPortNumber");
        this.signingCertificateChain = signingCertificateChain;
        this.signingPrivateKey = signingPrivateKey;
        this.decryptingPrivateKey = decryptingPrivateKey;
        this.validateSigningCertificateChain = validateSigningCertificateChain;
        this.signingAlgorithm = signingAlgorithm;
        this.listenerThread = new RequestListenerThread(this.as2Version, this.originServer, this.serverFqdn, parserServerPortNumber, signingAlgorithm, this.signingCertificateChain, this.signingPrivateKey, this.decryptingPrivateKey, mdnMessageTemplate, validateSigningCertificateChain, sslContext);
        this.listenerThread.setDaemon(true);
        this.listenerThread.start();
    }

    public Certificate[] getValidateSigningCertificateChain() {
        return this.validateSigningCertificateChain;
    }

    public PrivateKey getSigningPrivateKey() {
        return this.signingPrivateKey;
    }

    public PrivateKey getDecryptingPrivateKey() {
        return this.decryptingPrivateKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.listenerThread != null) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.listenerThread.serversocket.close();
                }
                catch (IOException e) {
                    LOG.debug(e.getMessage(), (Throwable)e);
                }
                finally {
                    this.listenerThread = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listen(String requestUri, HttpRequestHandler handler) {
        if (this.listenerThread != null) {
            Object object = this.lock;
            synchronized (object) {
                this.listenerThread.registerHandler(requestUri, handler);
            }
        }
    }

    protected HttpProcessor initProtocolProcessor(String as2Version, String originServer, String serverFqdn, AS2SignatureAlgorithm signatureAlgorithm, Certificate[] signingCertificateChain, PrivateKey signingPrivateKey, PrivateKey decryptingPrivateKey, String mdnMessageTemplate, Certificate[] validateSigningCertificateChain) {
        return HttpProcessorBuilder.create().add((HttpResponseInterceptor)new ResponseContent(true)).add((HttpResponseInterceptor)new ResponseServer(originServer)).add((HttpResponseInterceptor)new ResponseDate()).add((HttpResponseInterceptor)new ResponseConnControl()).add((HttpResponseInterceptor)new ResponseMDN(as2Version, serverFqdn, signatureAlgorithm, signingCertificateChain, signingPrivateKey, decryptingPrivateKey, mdnMessageTemplate, validateSigningCertificateChain)).build();
    }

    class RequestListenerThread
    extends Thread {
        private final ServerSocket serversocket;
        private final HttpService httpService;
        private final RequestHandlerRegistry registry;
        private final HttpServerRequestHandler handler;

        public RequestListenerThread(String as2Version, String originServer, String serverFqdn, int port, AS2SignatureAlgorithm signatureAlgorithm, Certificate[] signingCertificateChain, PrivateKey signingPrivateKey, PrivateKey decryptingPrivateKey, String mdnMessageTemplate, Certificate[] validateSigningCertificateChain, SSLContext sslContext) throws IOException {
            this.setName(AS2ServerConnection.REQUEST_LISTENER_THREAD_NAME_PREFIX + port);
            if (sslContext == null) {
                this.serversocket = new ServerSocket(port);
            } else {
                SSLServerSocketFactory factory = sslContext.getServerSocketFactory();
                this.serversocket = factory.createServerSocket(port);
            }
            HttpProcessor inhttpproc = AS2ServerConnection.this.initProtocolProcessor(as2Version, originServer, serverFqdn, signatureAlgorithm, signingCertificateChain, signingPrivateKey, decryptingPrivateKey, mdnMessageTemplate, validateSigningCertificateChain);
            this.registry = new RequestHandlerRegistry();
            this.handler = new BasicHttpServerRequestHandler((HttpRequestMapper)this.registry);
            this.httpService = new HttpService(inhttpproc, this.handler);
        }

        @Override
        public void run() {
            LOG.info("Listening on port {}", (Object)this.serversocket.getLocalPort());
            while (!Thread.interrupted()) {
                try {
                    Socket inSocket = this.serversocket.accept();
                    RequestHandlerThread t = new RequestHandlerThread(this.httpService, inSocket);
                    t.setDaemon(true);
                    t.start();
                }
                catch (InterruptedIOException | SocketException ex) {
                    break;
                }
                catch (IOException e) {
                    LOG.error("I/O error initialising connection thread: {}", (Object)e.getMessage());
                    break;
                }
            }
        }

        void registerHandler(String requestUriPattern, HttpRequestHandler httpRequestHandler) {
            this.registry.register(null, requestUriPattern, (Object)httpRequestHandler);
        }
    }

    class RequestHandlerThread
    extends Thread {
        private final HttpService httpService;
        private final HttpServerConnection serverConnection;

        public RequestHandlerThread(HttpService httpService, Socket inSocket) throws IOException {
            int bufSize = 8192;
            Http1Config cfg = Http1Config.custom().setBufferSize(8192).build();
            AS2BHttpServerConnection inConn = new AS2BHttpServerConnection(cfg);
            LOG.info("Incoming connection from {}", (Object)inSocket.getInetAddress());
            inConn.bind(inSocket);
            this.setName(AS2ServerConnection.REQUEST_HANDLER_THREAD_NAME_PREFIX + this.getId());
            this.httpService = httpService;
            this.serverConnection = inConn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info("Processing new AS2 request");
            BasicHttpContext context = new BasicHttpContext(null);
            try {
                while (!Thread.interrupted()) {
                    this.httpService.handleRequest(this.serverConnection, (HttpContext)context);
                    HttpCoreContext coreContext = HttpCoreContext.adapt((HttpContext)context);
                    String recipientAddress = (String)coreContext.getAttribute("camel-as2.async-mdn.recipient-address", String.class);
                    if (recipientAddress == null) continue;
                    DispositionNotificationMultipartReportEntity multipartReportEntity = (DispositionNotificationMultipartReportEntity)((Object)coreContext.getAttribute("camel-as2.async-mdn.asynchronous-mdn", DispositionNotificationMultipartReportEntity.class));
                    AS2AsynchronousMDNManager asynchronousMDNManager = new AS2AsynchronousMDNManager(AS2ServerConnection.this.as2Version, AS2ServerConnection.this.originServer, AS2ServerConnection.this.serverFqdn, AS2ServerConnection.this.signingCertificateChain, AS2ServerConnection.this.signingPrivateKey);
                    HttpRequest request = (HttpRequest)coreContext.getAttribute("http.request", HttpRequest.class);
                    AS2SignedDataGenerator gen = ResponseMDN.createSigningGenerator(request, AS2ServerConnection.this.signingAlgorithm, AS2ServerConnection.this.signingCertificateChain, AS2ServerConnection.this.signingPrivateKey);
                    DispositionNotificationMultipartReportEntity asyncReceipt = multipartReportEntity;
                    if (gen != null) {
                        MultipartSignedEntity multipartSignedEntity = null;
                        try {
                            multipartSignedEntity = ResponseMDN.prepareSignedReceipt(gen, multipartReportEntity);
                        }
                        catch (Exception e) {
                            LOG.warn("failed to sign MDN");
                        }
                        if (multipartSignedEntity == null) continue;
                        asynchronousMDNManager.send(multipartSignedEntity, multipartSignedEntity.getContentType(), recipientAddress);
                        continue;
                    }
                    asynchronousMDNManager.send(multipartReportEntity, multipartReportEntity.getMainMessageContentType(), recipientAddress);
                }
            }
            catch (ConnectionClosedException ex) {
                LOG.info("Client closed connection");
            }
            catch (IOException ex) {
                LOG.error("I/O error: {}", (Object)ex.getMessage());
            }
            catch (HttpException ex) {
                LOG.error("Unrecoverable HTTP protocol violation: {}", (Object)ex.getMessage(), (Object)ex);
            }
            finally {
                try {
                    this.serverConnection.close();
                }
                catch (IOException ex) {}
            }
        }
    }
}

