/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.util;

import java.util.ArrayList;
import java.util.BitSet;
import org.apache.camel.component.as2.api.entity.Importance;
import org.apache.camel.util.ObjectHelper;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.ParserCursor;
import org.apache.http.message.TokenParser;
import org.apache.http.util.CharArrayBuffer;

public final class AS2HeaderUtils {
    private static final char PARAM_DELIMITER = ',';
    private static final char ELEM_DELIMITER = ';';
    private static final char NAME_VALUE_DELIMITER = '=';
    private static final TokenParser TOKEN_PARSER = TokenParser.INSTANCE;
    private static final BitSet TOKEN_DELIMS = TokenParser.INIT_BITSET((int[])new int[]{61, 44, 59});
    private static final BitSet VALUE_DELIMS = TokenParser.INIT_BITSET((int[])new int[]{44, 59});

    private AS2HeaderUtils() {
    }

    public static Header createHeader(String headerName, String[] ... elements) {
        StringBuilder sb = new StringBuilder();
        boolean firstElement = true;
        for (String[] element : elements) {
            if (element.length == 0) continue;
            if (firstElement) {
                firstElement = false;
            } else {
                sb.append(';');
            }
            sb.append(element[0]);
            if (element.length <= 1) continue;
            sb.append("=" + element[1]);
        }
        BasicHeader header = new BasicHeader(headerName, sb.toString());
        return header;
    }

    public static Parameter parseParameter(CharArrayBuffer buffer, ParserCursor cursor) {
        ObjectHelper.notNull((Object)buffer, (String)"Char array buffer");
        ObjectHelper.notNull((Object)cursor, (String)"Parser cursor");
        String name = TOKEN_PARSER.parseToken(buffer, cursor, TOKEN_DELIMS);
        if (cursor.atEnd()) {
            return new Parameter(name, null, null);
        }
        char delim = buffer.charAt(cursor.getPos());
        cursor.updatePos(cursor.getPos() + 1);
        if (delim != '=') {
            return new Parameter(name, null, null);
        }
        String importance = TOKEN_PARSER.parseValue(buffer, cursor, VALUE_DELIMS);
        if (!cursor.atEnd()) {
            cursor.updatePos(cursor.getPos() + 1);
        }
        ArrayList<String> values = new ArrayList<String>();
        while (!cursor.atEnd()) {
            String value = TOKEN_PARSER.parseValue(buffer, cursor, VALUE_DELIMS);
            values.add(value);
            if (cursor.atEnd()) break;
            char delimiter = buffer.charAt(cursor.getPos());
            if (!cursor.atEnd()) {
                cursor.updatePos(cursor.getPos() + 1);
            }
            if (delimiter != ';') continue;
            break;
        }
        return new Parameter(name, importance, values.toArray(new String[values.size()]));
    }

    public static String getParameterValue(Header[] headers, String headerName, String parameterName) {
        ObjectHelper.notNull((Object)headers, (String)"headers");
        ObjectHelper.notNull((Object)headerName, (String)"headerName");
        for (Header header : headers) {
            if (!header.getName().equalsIgnoreCase(headerName)) continue;
            for (HeaderElement headerElement : header.getElements()) {
                for (NameValuePair nameValuePair : headerElement.getParameters()) {
                    if (!nameValuePair.getName().equalsIgnoreCase(parameterName)) continue;
                    return nameValuePair.getValue();
                }
            }
        }
        return null;
    }

    public static class Parameter {
        private final String attribute;
        private final Importance importance;
        private final String[] values;

        public Parameter(String attribute, String importance, String[] values) {
            this.attribute = (String)ObjectHelper.notNull((Object)attribute, (String)"attribute");
            this.importance = Importance.get(importance);
            this.values = values;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public Importance getImportance() {
            return this.importance;
        }

        public String[] getValues() {
            return this.values;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.attribute);
            if (this.importance != null) {
                sb.append("=" + this.importance.toString());
            }
            if (this.values != null) {
                for (String value : this.values) {
                    sb.append("," + value);
                }
            }
            return sb.toString();
        }
    }
}

