/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.entity;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.camel.component.as2.api.CanonicalOutputStream;
import org.apache.camel.component.as2.api.entity.MimeEntity;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.entity.ContentType;
import org.apache.http.util.Args;

public class TextPlainEntity
extends MimeEntity {
    private String content;

    public TextPlainEntity(String content, String charset, String contentTransferEncoding, boolean isMainBody) {
        this.content = (String)Args.notNull((Object)content, (String)"Content");
        this.setContentType(ContentType.create((String)"text/plain", (String)charset));
        this.setContentTransferEncoding(contentTransferEncoding);
        this.setMainBody(isMainBody);
    }

    public String getText() {
        return this.content;
    }

    public void writeTo(OutputStream outstream) throws IOException {
        MimeEntity.NoCloseOutputStream ncos = new MimeEntity.NoCloseOutputStream(outstream);
        try (CanonicalOutputStream canonicalOutstream = new CanonicalOutputStream(ncos, StandardCharsets.US_ASCII.name());){
            if (!this.isMainBody()) {
                HeaderIterator it = this.headerIterator();
                while (it.hasNext()) {
                    Header header = it.nextHeader();
                    canonicalOutstream.writeln(header.toString());
                }
                canonicalOutstream.writeln();
            }
            canonicalOutstream.write(this.content.getBytes(StandardCharsets.US_ASCII), 0, this.content.length());
        }
    }
}

