/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.arangodb;

import com.arangodb.ArangoCollection;
import com.arangodb.ArangoCursor;
import com.arangodb.ArangoDatabase;
import com.arangodb.ArangoEdgeCollection;
import com.arangodb.ArangoGraph;
import com.arangodb.ArangoVertexCollection;
import com.arangodb.entity.BaseDocument;
import com.arangodb.entity.BaseEdgeDocument;
import com.arangodb.model.AqlQueryOptions;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.arangodb.ArangoDbEndpoint;
import org.apache.camel.component.arangodb.ArangoDbOperation;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.MessageHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArangoDbProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(ArangoDbProducer.class);
    private final ArangoDbEndpoint endpoint;
    private final Map<ArangoDbOperation, Processor> operations = new EnumMap<ArangoDbOperation, Processor>(ArangoDbOperation.class);

    public ArangoDbProducer(ArangoDbEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.bind(ArangoDbOperation.SAVE_DOCUMENT, this.saveDocument());
        this.bind(ArangoDbOperation.FIND_DOCUMENT_BY_KEY, this.findDocumentByKey());
        this.bind(ArangoDbOperation.UPDATE_DOCUMENT, this.updateDocument());
        this.bind(ArangoDbOperation.DELETE_DOCUMENT, this.deleteDocument());
        this.bind(ArangoDbOperation.AQL_QUERY, this.aqlQuery());
        this.bind(ArangoDbOperation.SAVE_VERTEX, this.saveVertex());
        this.bind(ArangoDbOperation.UPDATE_VERTEX, this.updateVertex());
        this.bind(ArangoDbOperation.DELETE_VERTEX, this.deleteVertex());
        this.bind(ArangoDbOperation.FIND_VERTEX_BY_KEY, this.findVertexByKey());
        this.bind(ArangoDbOperation.SAVE_EDGE, this.saveEdge());
        this.bind(ArangoDbOperation.UPDATE_EDGE, this.updateEdge());
        this.bind(ArangoDbOperation.FIND_EDGE_BY_KEY, this.findEdgeByKey());
        this.bind(ArangoDbOperation.DELETE_EDGE, this.deleteEdge());
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        ArangoDbOperation operation = this.endpoint.getConfiguration().getOperation();
        this.invokeOperation(operation, exchange);
    }

    private void bind(ArangoDbOperation operation, Function<Exchange, Object> arangoDbFunction) {
        this.operations.put(operation, this.wrap(arangoDbFunction));
    }

    private Processor wrap(Function<Exchange, Object> supplier) {
        return exchange -> {
            Object result = supplier.apply(exchange);
            this.copyHeaders(exchange);
            this.processAndTransferResult(result, exchange);
        };
    }

    private void copyHeaders(Exchange exchange) {
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getMessage(), (boolean)false);
    }

    private void processAndTransferResult(Object result, Exchange exchange) {
        exchange.getMessage().setBody(result);
    }

    protected void invokeOperation(ArangoDbOperation operation, Exchange exchange) throws Exception {
        Processor processor = this.operations.get((Object)operation);
        if (processor == null) {
            throw new RuntimeCamelException("Operation not supported. Value: " + operation);
        }
        processor.process(exchange);
    }

    private Function<Exchange, Object> saveDocument() {
        return exchange -> {
            try {
                ArangoCollection collection = this.calculateDocumentCollection();
                boolean isMultiInsert = (Boolean)exchange.getMessage().getHeader("CamelArangoDbMultiInsert", (Object)false, Boolean.class);
                if (isMultiInsert) {
                    Collection objects = (Collection)exchange.getMessage().getMandatoryBody(Collection.class);
                    return collection.insertDocuments(objects);
                }
                Object obj = exchange.getMessage().getMandatoryBody();
                return collection.insertDocument(obj);
            }
            catch (InvalidPayloadException e) {
                throw new RuntimeCamelException("Invalid payload for command", (Throwable)e);
            }
        };
    }

    private Function<Exchange, Object> findDocumentByKey() {
        return exchange -> {
            try {
                ArangoCollection collection = this.calculateDocumentCollection();
                String key = (String)exchange.getIn().getMandatoryBody(String.class);
                Class<BaseDocument> resultClassType = (Class<BaseDocument>)exchange.getIn().getHeader("ResultClassType");
                resultClassType = resultClassType != null ? resultClassType : BaseDocument.class;
                return collection.getDocument(key, resultClassType);
            }
            catch (InvalidPayloadException e) {
                throw new RuntimeCamelException("Invalid payload for command", (Throwable)e);
            }
        };
    }

    private Function<Exchange, Object> updateDocument() {
        return exchange -> {
            try {
                ArangoCollection collection = this.calculateDocumentCollection();
                boolean isMultiUpdate = (Boolean)exchange.getMessage().getHeader("CamelArangoDbMultiUpdate", (Object)false, Boolean.class);
                if (isMultiUpdate) {
                    Collection documents = (Collection)exchange.getMessage().getMandatoryBody(Collection.class);
                    return collection.updateDocuments(documents);
                }
                String key = (String)exchange.getMessage().getHeader("key");
                Object document = exchange.getMessage().getMandatoryBody();
                return collection.updateDocument(key, document);
            }
            catch (InvalidPayloadException e) {
                throw new RuntimeCamelException("Invalid payload for command", (Throwable)e);
            }
        };
    }

    private Function<Exchange, Object> deleteDocument() {
        return exchange -> {
            try {
                ArangoCollection collection = this.calculateDocumentCollection();
                boolean isMultiUpdate = (Boolean)exchange.getMessage().getHeader("CamelArangoDbMultiDelete", (Object)false, Boolean.class);
                if (isMultiUpdate) {
                    Collection keysToDelete = (Collection)exchange.getMessage().getMandatoryBody(Collection.class);
                    return collection.deleteDocuments(keysToDelete);
                }
                String singleKey = (String)exchange.getMessage().getMandatoryBody(String.class);
                return collection.deleteDocument(singleKey);
            }
            catch (InvalidPayloadException e) {
                throw new RuntimeCamelException("Invalid payload for command", (Throwable)e);
            }
        };
    }

    private Function<Exchange, Object> saveVertex() {
        return exchange -> {
            try {
                ArangoVertexCollection vertexCollection = this.calculateVertexCollection();
                Object vertexDocument = exchange.getMessage().getMandatoryBody();
                return vertexCollection.insertVertex(vertexDocument);
            }
            catch (InvalidPayloadException e) {
                throw new RuntimeCamelException("Invalid payload for command", (Throwable)e);
            }
        };
    }

    private Function<Exchange, Object> updateVertex() {
        return exchange -> {
            try {
                ArangoVertexCollection vertexCollection = this.calculateVertexCollection();
                String key = (String)exchange.getMessage().getHeader("key");
                Object vertexDocument = exchange.getMessage().getMandatoryBody();
                return vertexCollection.updateVertex(key, vertexDocument);
            }
            catch (InvalidPayloadException e) {
                throw new RuntimeCamelException("Invalid payload for command", (Throwable)e);
            }
        };
    }

    private Function<Exchange, Object> deleteVertex() {
        return exchange -> {
            try {
                ArangoVertexCollection vertexCollection = this.calculateVertexCollection();
                String singleKey = (String)exchange.getMessage().getMandatoryBody(String.class);
                vertexCollection.deleteVertex(singleKey);
                return true;
            }
            catch (InvalidPayloadException e) {
                throw new RuntimeCamelException("Invalid payload for command", (Throwable)e);
            }
        };
    }

    private Function<Exchange, Object> findVertexByKey() {
        return exchange -> {
            try {
                ArangoVertexCollection vertexCollection = this.calculateVertexCollection();
                String key = (String)exchange.getIn().getMandatoryBody(String.class);
                Class<BaseDocument> resultClassType = (Class<BaseDocument>)exchange.getIn().getHeader("ResultClassType");
                resultClassType = resultClassType != null ? resultClassType : BaseDocument.class;
                return vertexCollection.getVertex(key, resultClassType);
            }
            catch (InvalidPayloadException e) {
                throw new RuntimeCamelException("Invalid payload for command", (Throwable)e);
            }
        };
    }

    private Function<Exchange, Object> saveEdge() {
        return exchange -> {
            try {
                ArangoEdgeCollection edgeCollection = this.calculateEdgeCollection();
                Object edgeDocument = exchange.getMessage().getMandatoryBody();
                return edgeCollection.insertEdge(edgeDocument);
            }
            catch (InvalidPayloadException e) {
                throw new RuntimeCamelException("Invalid payload for command", (Throwable)e);
            }
        };
    }

    private Function<Exchange, Object> updateEdge() {
        return exchange -> {
            try {
                ArangoEdgeCollection edgeCollection = this.calculateEdgeCollection();
                String key = (String)exchange.getMessage().getHeader("key");
                Object edgeDocument = exchange.getMessage().getMandatoryBody();
                return edgeCollection.updateEdge(key, edgeDocument);
            }
            catch (InvalidPayloadException e) {
                throw new RuntimeCamelException("Invalid payload for command", (Throwable)e);
            }
        };
    }

    private Function<Exchange, Object> deleteEdge() {
        return exchange -> {
            try {
                ArangoEdgeCollection edgeCollection = this.calculateEdgeCollection();
                String singleKey = (String)exchange.getMessage().getMandatoryBody(String.class);
                edgeCollection.deleteEdge(singleKey);
                return true;
            }
            catch (InvalidPayloadException e) {
                throw new RuntimeCamelException("Invalid payload for command", (Throwable)e);
            }
        };
    }

    private Function<Exchange, Object> findEdgeByKey() {
        return exchange -> {
            try {
                ArangoEdgeCollection edgeCollection = this.calculateEdgeCollection();
                String key = (String)exchange.getIn().getMandatoryBody(String.class);
                Class<BaseEdgeDocument> resultClassType = (Class<BaseEdgeDocument>)exchange.getIn().getHeader("ResultClassType");
                resultClassType = resultClassType != null ? resultClassType : BaseEdgeDocument.class;
                return edgeCollection.getEdge(key, resultClassType);
            }
            catch (InvalidPayloadException e) {
                throw new RuntimeCamelException("Invalid payload for command", (Throwable)e);
            }
        };
    }

    private Function<Exchange, Object> aqlQuery() {
        return exchange -> {
            List list;
            ArangoDatabase database = this.endpoint.getArangoDB().db(this.endpoint.getConfiguration().getDatabase());
            String query = (String)exchange.getMessage().getHeader("CamelArangoDbAqlQuery");
            if (query == null) {
                query = (String)exchange.getMessage().getMandatoryBody(String.class);
            }
            Map bindParameters = (Map)exchange.getMessage().getHeader("CamelArangoDbAqlParameters", Map.class);
            AqlQueryOptions queryOptions = (AqlQueryOptions)exchange.getMessage().getHeader("CamelArangoDbAqlOptions");
            Class<BaseDocument> resultClassType = (Class<BaseDocument>)exchange.getIn().getHeader("ResultClassType");
            resultClassType = resultClassType != null ? resultClassType : BaseDocument.class;
            ArangoCursor cursor = database.query(query, resultClassType, bindParameters, queryOptions);
            try {
                List list2 = list = cursor == null ? null : cursor.asListRemaining();
                if (cursor == null) return list;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (cursor == null) throw throwable;
                        try {
                            cursor.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to close instance of ArangoCursor", (Throwable)e);
                        return null;
                    }
                }
                catch (InvalidPayloadException e) {
                    throw new RuntimeCamelException("Invalid payload for command", (Throwable)e);
                }
            }
            cursor.close();
            return list;
        };
    }

    private ArangoCollection calculateDocumentCollection() {
        String database = this.endpoint.getConfiguration().getDatabase();
        String collection = this.endpoint.getConfiguration().getDocumentCollection();
        return this.endpoint.getArangoDB().db(database).collection(collection);
    }

    private ArangoGraph calculateGraph() {
        String database = this.endpoint.getConfiguration().getDatabase();
        String graph = this.endpoint.getConfiguration().getGraph();
        return this.endpoint.getArangoDB().db(database).graph(graph);
    }

    private ArangoVertexCollection calculateVertexCollection() {
        String vertexCollection = this.endpoint.getConfiguration().getVertexCollection();
        return this.calculateGraph().vertexCollection(vertexCollection);
    }

    private ArangoEdgeCollection calculateEdgeCollection() {
        String edgeCollection = this.endpoint.getConfiguration().getEdgeCollection();
        return this.calculateGraph().edgeCollection(edgeCollection);
    }
}

