/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;

public class NoSuchHeaderOrPropertyException
extends CamelExchangeException {
    private final String headerName;
    private final String propertyName;
    private final transient Class<?> type;

    public NoSuchHeaderOrPropertyException(Exchange exchange, String headerName, String propertyName, Class<?> type) {
        super(String.format("Np '%s' header or '%s' property available of type: %s (header: %s, property: %s)", headerName, propertyName, type.getName(), NoSuchHeaderOrPropertyException.header(exchange, headerName), NoSuchHeaderOrPropertyException.property(exchange, headerName)), exchange);
        this.headerName = headerName;
        this.propertyName = propertyName;
        this.type = type;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Class<?> getType() {
        return this.type;
    }

    protected static String header(Exchange exchange, String headerName) {
        Object value = exchange.getMessage().getHeader(headerName);
        return NoSuchHeaderOrPropertyException.valueDescription(value);
    }

    protected static String property(Exchange exchange, String propertyName) {
        Object value = exchange.getProperty(propertyName);
        return NoSuchHeaderOrPropertyException.valueDescription(value);
    }

    static String valueDescription(Object value) {
        if (value == null) {
            return "null";
        }
        return "has value: " + value + " of type: " + value.getClass().getCanonicalName();
    }
}

