/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.console;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.StaticService;
import org.apache.camel.console.DevConsole;
import org.apache.camel.spi.IdAware;
import org.apache.camel.util.ObjectHelper;

public interface DevConsoleRegistry
extends CamelContextAware,
StaticService,
IdAware {
    public static final String NAME = "default-registry";
    public static final String FACTORY = "dev-console/default-registry";

    public boolean isEnabled();

    public void setEnabled(boolean var1);

    public DevConsole resolveById(String var1);

    public boolean register(DevConsole var1);

    public boolean unregister(DevConsole var1);

    default public Collection<String> getConsoleIDs() {
        return this.stream().map(DevConsole::getId).collect(Collectors.toList());
    }

    default public Optional<DevConsole> getConsole(String id) {
        return this.stream().filter(r -> ObjectHelper.equal((Object)r.getId(), (Object)id)).findFirst();
    }

    public static DevConsoleRegistry get(CamelContext context) {
        return context.getExtension(DevConsoleRegistry.class);
    }

    public Stream<DevConsole> stream();

    public void loadDevConsoles();
}

