/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ahc.helper;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.ahc.AhcEndpoint;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.URISupport;

public final class AhcHelper {
    private AhcHelper() {
    }

    public static void writeObjectToStream(OutputStream stream, Object target) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(stream);
        oos.writeObject(target);
        oos.flush();
        IOHelper.close((Closeable)oos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserializeJavaObjectFromStream(InputStream is) throws ClassNotFoundException, IOException {
        if (is == null) {
            return null;
        }
        Object answer = null;
        ObjectInputStream ois = new ObjectInputStream(is);
        try {
            answer = ois.readObject();
        }
        finally {
            IOHelper.close((Closeable)ois);
        }
        return answer;
    }

    public static void setCharsetFromContentType(String contentType, Exchange exchange) {
        int index;
        if (contentType != null && (index = contentType.indexOf("charset=")) > 0) {
            String charset = contentType.substring(index + 8);
            exchange.setProperty("CamelCharsetName", (Object)IOConverter.normalizeCharset((String)charset));
        }
    }

    public static String createURL(Exchange exchange, AhcEndpoint endpoint) throws URISyntaxException {
        String url = AhcHelper.doCreateURL(exchange, endpoint);
        return URISupport.normalizeUri((String)url);
    }

    private static String doCreateURL(Exchange exchange, AhcEndpoint endpoint) {
        String uri = null;
        if (!endpoint.isBridgeEndpoint()) {
            uri = (String)exchange.getIn().getHeader("CamelHttpUri", String.class);
        }
        if (uri == null) {
            uri = endpoint.getHttpUri().toASCIIString();
        }
        try {
            uri = exchange.getContext().resolvePropertyPlaceholders(uri);
        }
        catch (Exception e) {
            throw new RuntimeExchangeException("Cannot resolve property placeholders with uri: " + uri, exchange, (Throwable)e);
        }
        String path = (String)exchange.getIn().getHeader("CamelHttpPath", String.class);
        if (path != null) {
            block13: {
                if (path.startsWith("/")) {
                    String baseURIString = (String)exchange.getIn().getHeader("CamelHttpBaseUri", String.class);
                    try {
                        URI baseURI;
                        String basePath;
                        if (baseURIString == null) {
                            baseURIString = exchange.getFromEndpoint() != null ? exchange.getFromEndpoint().getEndpointUri() : "/";
                        }
                        if (path.startsWith(basePath = (baseURI = new URI(baseURIString)).getRawPath())) {
                            if ((path = path.substring(basePath.length())).startsWith("/")) {
                                path = path.substring(1);
                            }
                            break block13;
                        }
                        throw new RuntimeExchangeException("Cannot analyze the Exchange.HTTP_PATH header, due to: cannot find the right HTTP_BASE_URI", exchange);
                    }
                    catch (Throwable t) {
                        throw new RuntimeExchangeException("Cannot analyze the Exchange.HTTP_PATH header, due to: " + t.getMessage(), exchange, t);
                    }
                }
            }
            if (path.length() > 0) {
                if (!uri.endsWith("/")) {
                    uri = uri + "/";
                }
                uri = uri.concat(path);
            }
        }
        return uri;
    }
}

