/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ahc;

import com.ning.http.client.BodyGenerator;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.generators.ByteArrayBodyGenerator;
import com.ning.http.client.generators.FileBodyGenerator;
import com.ning.http.client.generators.InputStreamBodyGenerator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.ahc.AhcBinding;
import org.apache.camel.component.ahc.AhcEndpoint;
import org.apache.camel.component.ahc.AhcOperationFailedException;
import org.apache.camel.component.ahc.helper.AhcHelper;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.GZIPHelper;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAhcBinding
implements AhcBinding {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public Request prepareRequest(AhcEndpoint endpoint, Exchange exchange) throws CamelExchangeException {
        if (endpoint.isBridgeEndpoint()) {
            exchange.setProperty("CamelSkipGzipEncoding", (Object)Boolean.TRUE);
        }
        RequestBuilder builder = new RequestBuilder();
        try {
            String url = AhcHelper.createURL(exchange, endpoint);
            this.log.trace("Setting url {}", (Object)url);
            builder.setUrl(url);
        }
        catch (URISyntaxException e) {
            throw new CamelExchangeException("Error creating URL", exchange, (Throwable)e);
        }
        String method = this.extractMethod(exchange);
        this.log.trace("Setting method {}", (Object)method);
        builder.setMethod(method);
        this.populateHeaders(builder, endpoint, exchange);
        this.populateBody(builder, endpoint, exchange);
        return builder.build();
    }

    protected String extractMethod(Exchange exchange) {
        String method = (String)exchange.getIn().getHeader("CamelHttpMethod", String.class);
        if (method != null) {
            return method;
        }
        boolean hasBody = exchange.getIn().getBody() != null;
        return hasBody ? "POST" : "GET";
    }

    protected void populateHeaders(RequestBuilder builder, AhcEndpoint endpoint, Exchange exchange) {
        HeaderFilterStrategy strategy = endpoint.getHeaderFilterStrategy();
        for (Map.Entry entry : exchange.getIn().getHeaders().entrySet()) {
            String headerValue = (String)exchange.getIn().getHeader((String)entry.getKey(), String.class);
            if (strategy == null || strategy.applyFilterToCamelHeaders((String)entry.getKey(), (Object)headerValue, exchange)) continue;
            this.log.trace("Adding header {} = {}", entry.getKey(), (Object)headerValue);
            builder.addHeader((String)entry.getKey(), headerValue);
        }
    }

    protected void populateBody(RequestBuilder builder, AhcEndpoint endpoint, Exchange exchange) throws CamelExchangeException {
        Message in = exchange.getIn();
        if (in.getBody() == null) {
            return;
        }
        String contentType = ExchangeHelper.getContentType((Exchange)exchange);
        BodyGenerator body = (BodyGenerator)in.getBody(BodyGenerator.class);
        String charset = IOConverter.getCharsetName((Exchange)exchange, (boolean)false);
        if (body == null) {
            try {
                Object data = in.getBody();
                if (data != null) {
                    if (contentType != null && "application/x-java-serialized-object".equals(contentType)) {
                        Serializable obj = (Serializable)in.getMandatoryBody(Serializable.class);
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        AhcHelper.writeObjectToStream(bos, obj);
                        byte[] bytes = bos.toByteArray();
                        body = new ByteArrayBodyGenerator(bytes);
                        IOHelper.close((Closeable)bos);
                    } else if (data instanceof File || data instanceof GenericFile) {
                        File file = (File)in.getBody(File.class);
                        if (file != null) {
                            body = new FileBodyGenerator(file);
                        }
                    } else if (data instanceof String) {
                        body = charset != null ? new ByteArrayBodyGenerator(((String)data).getBytes(charset)) : new ByteArrayBodyGenerator(((String)data).getBytes());
                    }
                    if (body == null) {
                        InputStream is = (InputStream)in.getMandatoryBody(InputStream.class);
                        body = new InputStreamBodyGenerator(is);
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new CamelExchangeException("Error creating BodyGenerator from message body", exchange, (Throwable)e);
            }
            catch (IOException e) {
                throw new CamelExchangeException("Error serializing message body", exchange, (Throwable)e);
            }
        }
        if (body != null) {
            this.log.trace("Setting body {}", (Object)body);
            builder.setBody(body);
        }
        if (charset != null) {
            this.log.trace("Setting body charset {}", (Object)charset);
            builder.setBodyEncoding(charset);
        }
        this.log.trace("Setting Content-Type {}", (Object)contentType);
        builder.setHeader("Content-Type", contentType);
    }

    @Override
    public void onThrowable(AhcEndpoint endpoint, Exchange exchange, Throwable t) throws Exception {
        exchange.setException(t);
    }

    @Override
    public void onStatusReceived(AhcEndpoint endpoint, Exchange exchange, HttpResponseStatus responseStatus) throws Exception {
        exchange.getOut().setHeader("CamelHttpResponseCode", (Object)responseStatus.getStatusCode());
    }

    @Override
    public void onHeadersReceived(AhcEndpoint endpoint, Exchange exchange, HttpResponseHeaders headers) throws Exception {
        for (Map.Entry entry : headers.getHeaders().entrySet()) {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            if (value.size() == 1) {
                exchange.getOut().getHeaders().put(key, value.get(0));
                continue;
            }
            exchange.getOut().getHeaders().put(key, value);
        }
    }

    @Override
    public void onComplete(AhcEndpoint endpoint, Exchange exchange, String url, ByteArrayOutputStream os, int contentLength, int statusCode, String statusText) throws Exception {
        String contentType;
        os.flush();
        os.close();
        InputStream is = new ByteArrayInputStream(os.toByteArray());
        String contentEncoding = (String)exchange.getOut().getHeader("Content-Encoding", String.class);
        if (!((Boolean)exchange.getProperty("CamelSkipGzipEncoding", (Object)Boolean.FALSE, Boolean.class)).booleanValue()) {
            is = GZIPHelper.uncompressGzip((String)contentEncoding, (InputStream)is);
        }
        if ((contentType = (String)exchange.getOut().getHeader("Content-Type", String.class)) != null) {
            AhcHelper.setCharsetFromContentType(contentType, exchange);
        }
        Object body = is;
        if (contentType != null && contentType.equals("application/x-java-serialized-object")) {
            body = AhcHelper.deserializeJavaObjectFromStream(is);
        }
        if (!endpoint.isThrowExceptionOnFailure()) {
            this.populateResponse(exchange, body, contentLength, statusCode);
        } else if (statusCode >= 100 && statusCode < 300) {
            this.populateResponse(exchange, body, contentLength, statusCode);
        } else {
            throw this.populateHttpOperationFailedException(endpoint, exchange, url, body, contentLength, statusCode, statusText);
        }
    }

    private Exception populateHttpOperationFailedException(AhcEndpoint endpoint, Exchange exchange, String url, Object body, int contentLength, int statusCode, String statusText) {
        String redirectLocation;
        if (endpoint.isTransferException() && body != null && body instanceof Exception) {
            return (Exception)body;
        }
        String copy = null;
        if (body != null) {
            copy = (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, body);
        }
        Map<String, String> headers = this.extractResponseHeaders(exchange);
        AhcOperationFailedException answer = statusCode >= 300 && statusCode < 400 ? ((redirectLocation = (String)exchange.getOut().getHeader("Location", String.class)) != null ? new AhcOperationFailedException(url, statusCode, statusText, redirectLocation, headers, copy) : new AhcOperationFailedException(url, statusCode, statusText, null, headers, copy)) : new AhcOperationFailedException(url, statusCode, statusText, null, headers, copy);
        return answer;
    }

    private Map<String, String> extractResponseHeaders(Exchange exchange) {
        LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
        for (Map.Entry entry : exchange.getOut().getHeaders().entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)exchange.getContext().getTypeConverter().convertTo(String.class, entry.getValue());
            if (value == null) continue;
            answer.put(key, value);
        }
        return answer;
    }

    private void populateResponse(Exchange exchange, Object body, int contentLength, int responseCode) {
        exchange.getOut().setBody(body);
        exchange.getOut().setHeader("Content-Length", (Object)contentLength);
    }
}

