/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ahc;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import java.net.URI;
import javax.net.ssl.SSLContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.ahc.AhcBinding;
import org.apache.camel.component.ahc.AhcComponent;
import org.apache.camel.component.ahc.AhcProducer;
import org.apache.camel.component.ahc.HttpHeaderFilterStrategy;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.jsse.SSLContextParameters;

public class AhcEndpoint
extends DefaultEndpoint
implements HeaderFilterStrategyAware {
    private AsyncHttpClient client;
    private AsyncHttpClientConfig clientConfig;
    private HeaderFilterStrategy headerFilterStrategy = new HttpHeaderFilterStrategy();
    private AhcBinding binding;
    private URI httpUri;
    private boolean bridgeEndpoint;
    private boolean throwExceptionOnFailure = true;
    private boolean transferException;
    private SSLContextParameters sslContextParameters;
    private int bufferSize = 4096;

    public AhcEndpoint(String endpointUri, AhcComponent component, URI httpUri) {
        super(endpointUri, (Component)component);
        this.httpUri = httpUri;
    }

    public AhcComponent getComponent() {
        return (AhcComponent)super.getComponent();
    }

    public Producer createProducer() throws Exception {
        ObjectHelper.notNull((Object)this.client, (String)"AsyncHttpClient", (Object)((Object)this));
        ObjectHelper.notNull((Object)this.httpUri, (String)"HttpUri", (Object)((Object)this));
        ObjectHelper.notNull((Object)this.binding, (String)"AhcBinding", (Object)((Object)this));
        return new AhcProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("This component does not support consuming from this endpoint");
    }

    public boolean isLenientProperties() {
        return true;
    }

    public boolean isSingleton() {
        return true;
    }

    public AsyncHttpClient getClient() {
        return this.client;
    }

    public void setClient(AsyncHttpClient client) {
        this.client = client;
    }

    public AsyncHttpClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public void setClientConfig(AsyncHttpClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public URI getHttpUri() {
        return this.httpUri;
    }

    public void setHttpUri(URI httpUri) {
        this.httpUri = httpUri;
    }

    public AhcBinding getBinding() {
        return this.binding;
    }

    public void setBinding(AhcBinding binding) {
        this.binding = binding;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public boolean isBridgeEndpoint() {
        return this.bridgeEndpoint;
    }

    public void setBridgeEndpoint(boolean bridgeEndpoint) {
        this.bridgeEndpoint = bridgeEndpoint;
    }

    public boolean isThrowExceptionOnFailure() {
        return this.throwExceptionOnFailure;
    }

    public void setThrowExceptionOnFailure(boolean throwExceptionOnFailure) {
        this.throwExceptionOnFailure = throwExceptionOnFailure;
    }

    public boolean isTransferException() {
        return this.transferException;
    }

    public void setTransferException(boolean transferException) {
        this.transferException = transferException;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.client == null) {
            AsyncHttpClientConfig config = null;
            if (this.clientConfig != null) {
                AsyncHttpClientConfig.Builder builder = AhcComponent.cloneConfig(this.clientConfig);
                if (this.sslContextParameters != null) {
                    SSLContext ssl = this.sslContextParameters.createSSLContext();
                    builder.setSSLContext(ssl);
                }
                config = builder.build();
            } else if (this.sslContextParameters != null) {
                AsyncHttpClientConfig.Builder builder = new AsyncHttpClientConfig.Builder();
                SSLContext ssl = this.sslContextParameters.createSSLContext();
                builder.setSSLContext(ssl);
                config = builder.build();
            }
            this.client = config == null ? new AsyncHttpClient() : new AsyncHttpClient(config);
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.client != null && !this.client.isClosed()) {
            this.client.close();
        }
        this.client = null;
    }
}

