/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ahc;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.Realm;
import java.net.URI;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.ahc.AhcBinding;
import org.apache.camel.component.ahc.AhcEndpoint;
import org.apache.camel.component.ahc.DefaultAhcBinding;
import org.apache.camel.impl.HeaderFilterStrategyComponent;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AhcComponent
extends HeaderFilterStrategyComponent {
    private static final Logger LOG = LoggerFactory.getLogger(AhcComponent.class);
    private static final String CLIENT_CONFIG_PREFIX = "clientConfig.";
    private static final String CLIENT_REALM_CONFIG_PREFIX = "clientConfig.realm.";
    private AsyncHttpClient client;
    private AsyncHttpClientConfig clientConfig;
    private AhcBinding binding;
    private SSLContextParameters sslContextParameters;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String addressUri = remaining;
        AhcEndpoint endpoint = new AhcEndpoint(uri, this, null);
        this.setEndpointHeaderFilterStrategy((Endpoint)endpoint);
        endpoint.setClient(this.getClient());
        endpoint.setClientConfig(this.getClientConfig());
        endpoint.setBinding(this.getBinding());
        endpoint.setSslContextParameters(this.getSslContextParameters());
        this.setProperties((Object)endpoint, parameters);
        if (IntrospectionSupport.hasProperties(parameters, (String)CLIENT_CONFIG_PREFIX)) {
            AsyncHttpClientConfig.Builder builder;
            AsyncHttpClientConfig.Builder builder2 = builder = endpoint.getClientConfig() == null ? new AsyncHttpClientConfig.Builder() : AhcComponent.cloneConfig(endpoint.getClientConfig());
            if (endpoint.getClient() != null) {
                LOG.warn("The user explicitly set an AsyncHttpClient instance on the component or endpoint, but this endpoint URI contains client configuration parameters.  Are you sure that this is what was intended?  The AsyncHttpClient will be used and the URI parameters will be ignored.");
            } else if (endpoint.getClientConfig() != null) {
                LOG.warn("The user explicitly set an AsyncHttpClientConfig instance on the component or endpoint, but this endpoint URI contains client configuration parameters.  Are you sure that this is what was intended?  The URI parameters will be applied to a clone of the supplied AsyncHttpClientConfig in order to prevent unintended modification of the explicitly configured AsyncHttpClientConfig.  That is, the URI parameters override the settings on the explicitly configured AsyncHttpClientConfig for this endpoint.");
            }
            Realm.RealmBuilder realmBuilder = null;
            if (IntrospectionSupport.hasProperties(parameters, (String)CLIENT_REALM_CONFIG_PREFIX)) {
                realmBuilder = new Realm.RealmBuilder();
                Map realmParams = IntrospectionSupport.extractProperties(parameters, (String)CLIENT_REALM_CONFIG_PREFIX);
                this.setProperties(realmBuilder, realmParams);
                this.validateParameters(uri, realmParams, null);
            }
            Map clientParams = IntrospectionSupport.extractProperties(parameters, (String)CLIENT_CONFIG_PREFIX);
            this.setProperties(builder, clientParams);
            this.validateParameters(uri, clientParams, null);
            if (realmBuilder != null) {
                builder.setRealm(realmBuilder.build());
            }
            endpoint.setClientConfig(builder.build());
        }
        addressUri = UnsafeUriCharactersEncoder.encode((String)addressUri);
        URI httpUri = URISupport.createRemainingURI((URI)new URI(addressUri), parameters);
        endpoint.setHttpUri(httpUri);
        return endpoint;
    }

    public AsyncHttpClient getClient() {
        return this.client;
    }

    public void setClient(AsyncHttpClient client) {
        this.client = client;
    }

    public AhcBinding getBinding() {
        if (this.binding == null) {
            this.binding = new DefaultAhcBinding();
        }
        return this.binding;
    }

    public void setBinding(AhcBinding binding) {
        this.binding = binding;
    }

    public AsyncHttpClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public void setClientConfig(AsyncHttpClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    static AsyncHttpClientConfig.Builder cloneConfig(AsyncHttpClientConfig clientConfig) {
        AsyncHttpClientConfig.Builder builder = new AsyncHttpClientConfig.Builder(clientConfig);
        return builder;
    }
}

